/*
 * Copyright 2010-2015 Allette Systems (Australia)
 * http://www.allette.com.au
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.pageseeder.diffx.handler;

/**
 * A base class for handlers acting as filters for tokens
 */
public abstract class DiffFilter implements DiffHandler {

  /**
   * Target format.
   */
  protected final DiffHandler target;

  protected DiffFilter(DiffHandler target) {
    this.target = target;
  }

  @Override
  public void start() {
    this.target.start();
  }

  @Override
  public void end() {
    this.target.end();
  }
}
