/*
 * Copyright 2010-2015 Allette Systems (Australia)
 * http://www.allette.com.au
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.pageseeder.diffx.core;

import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.handler.CoalescingFilter;
import org.pageseeder.diffx.handler.CompareReplaceFilter;
import org.pageseeder.diffx.handler.DiffHandler;
import org.pageseeder.diffx.token.Token;

import java.util.List;

/**
 * @author Christophe Lauret
 * @version 0.9.0
 */
public final class ProgressiveXMLProcessor extends DiffProcessorBase implements DiffProcessor {

  @Override
  public void diff(List<? extends Token> first, List<? extends Token> second, DiffHandler handler) {
    MatrixXMLAlgorithm algorithm = new MatrixXMLAlgorithm();
    DiffHandler actual = handler;
    if (coalesce) actual = new CoalescingFilter(actual);
    actual = new CompareReplaceFilter(actual);
    actual.start();
    algorithm.diff(first, second, actual);
    actual.end();
  }

  @Override
  public String toString() {
    return "ProgressiveXMLProcessor{" +
        "coalesce=" + this.coalesce +
        '}';
  }
}
