/*
 * Decompiled with CFR 0.152.
 */
package org.overture.tools.overturetemplategen;

import java.util.Collections;
import java.util.Vector;
import org.overture.tools.overturetemplategen.EscapeChars;
import org.overture.tools.overturetemplategen.Template;

public class TemplateList
extends Vector<Template> {
    private String dialectName = "all";
    private static final long serialVersionUID = 1L;

    public TemplateList() {
    }

    public TemplateList(String dialectName) {
        this.dialectName = dialectName;
    }

    protected TemplateList getFilteredList(String dialect) {
        TemplateList templates = new TemplateList(dialect);
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("all") && !t.dialect.toLowerCase().contains(dialect.toLowerCase()) && (!dialect.toLowerCase().equals("vdmrt") || !t.dialect.toLowerCase().contains("vdmpp"))) continue;
            templates.add(t);
        }
        return templates;
    }

    public TemplateList getSlList() {
        return this.getFilteredList("vdmsl");
    }

    public TemplateList getPpList() {
        return this.getFilteredList("vdmpp");
    }

    public TemplateList getRtList() {
        return this.getFilteredList("vdmrt");
    }

    public String getTemplateFileContent() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        sb.append("<templates>\n");
        sb.append(this.getEntries());
        sb.append("</templates>\n");
        return sb.toString();
    }

    private String getEntries() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Template t : this) {
            sb.append("\n" + this.getXml(t));
        }
        sb.append("\n");
        return sb.toString();
    }

    private String getXml(Template t) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\t<template autoinsert=\"true\" context=\"");
        sb.append(this.getContextType());
        sb.append("\" deleted=\"false\" description=\"");
        sb.append(EscapeChars.forXML(t.description));
        sb.append("\" enabled=\"true\" name=\"");
        sb.append(t.name);
        sb.append("\" id=\"");
        sb.append(t.name + this.dialectName.toUpperCase());
        sb.append("\">");
        sb.append(EscapeChars.forXML(t.template));
        sb.append("</template>");
        return sb.toString();
    }

    public String getContextType() throws Exception {
        if (this.dialectName.toLowerCase().endsWith("vdmsl")) {
            return "org.overture.ide.vdmsl.ui.contextType";
        }
        if (this.dialectName.toLowerCase().endsWith("vdmpp")) {
            return "org.overture.ide.vdmpp.ui.contextType";
        }
        if (this.dialectName.toLowerCase().endsWith("vdmrt")) {
            return "org.overture.ide.vdmrt.ui.contextType";
        }
        throw new Exception("Context type");
    }

    @Override
    public synchronized String toString() {
        Collections.sort(this);
        StringBuilder sb = new StringBuilder();
        sb.append("All dialects:\n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("all")) continue;
            sb.append("\t" + t.name + "\n");
        }
        sb.append("\nVDM-SL:\n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("vdmsl")) continue;
            sb.append("\t" + t.name + "\n");
        }
        sb.append("\nVDM-PP:\n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("vdmpp")) continue;
            sb.append("\t" + t.name + "\n");
        }
        sb.append("\nVDM-RT:\n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("vdmrt") && !t.dialect.toLowerCase().contains("vdmpp")) continue;
            sb.append("\t" + t.name + "\n");
        }
        return sb.toString();
    }

    public String toLatexTable() {
        StringBuilder sb = new StringBuilder();
        int KEY_SIZE = 25;
        sb.append("\\begin{tabular}{ l p{9cm} }\n");
        sb.append("Key & Description\\\\\\hline");
        sb.append("\n% ALL \n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("all")) continue;
            sb.append(this.latex(this.pad(t.name, 25)) + " & " + this.latex(t.description) + "\\\\\n");
        }
        sb.append("\n% VDM-SL \n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("vdmsl")) continue;
            sb.append(this.latex(this.pad(t.name, 25)) + " & " + this.latex(t.description) + "\\\\\n");
        }
        sb.append("\n% VDM-PP \n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("vdmpp")) continue;
            sb.append(this.latex(this.pad(t.name, 25)) + " & " + this.latex(t.description) + "\\\\\n");
        }
        sb.append("\n% VDM-RT \n");
        for (Template t : this) {
            if (!t.dialect.toLowerCase().contains("vdmrt") && !t.dialect.toLowerCase().contains("vdmpp")) continue;
            sb.append(this.latex(this.pad(t.name, 25)) + " & " + this.latex(t.description) + "\\\\\n");
        }
        sb.append("\\end{tabular}\n");
        return sb.toString();
    }

    public String pad(String data, int size) {
        while (data.length() < size) {
            data = data + " ";
        }
        return data;
    }

    public String latex(String data) {
        return data.replaceAll("\\#", "\\\\#").replaceAll("\\&", "\\\\&").replaceAll("\\\\n", "");
    }
}

