/*
 * Decompiled with CFR 0.152.
 */
package org.overture.tools.overturetemplategen;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.overture.tools.overturetemplategen.Template;
import org.overture.tools.overturetemplategen.TemplateList;

public class Reader {
    private String current;
    BufferedReader reader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateList read(File file) throws Exception {
        TemplateList templates = new TemplateList();
        try {
            this.reader = new BufferedReader(new FileReader(file));
            this.readNextLine();
            while (this.current != null && this.current.startsWith("#name")) {
                templates.add(this.readTemplate());
                this.readNextLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return templates;
    }

    private String readNextLine() throws IOException {
        this.current = this.reader.readLine();
        if (this.current != null && this.current.startsWith("--")) {
            this.readNextLine();
            return this.current;
        }
        return this.current;
    }

    private Template readTemplate() throws Exception {
        String name = this.current.substring("#name".length()).replace('\t', ' ').trim();
        this.readNextLine();
        if (!this.current.startsWith("#description")) {
            throw new Exception("Wrong line: " + this.current);
        }
        String description = this.current.substring("#description".length()).replace('\t', ' ').trim();
        this.readNextLine();
        if (!this.current.startsWith("#dialect")) {
            throw new Exception("Wrong line: " + this.current);
        }
        String dialect = this.current.substring("#dialect".length()).trim();
        String template = this.readTemplateSyntax();
        return new Template(name, description, dialect, template);
    }

    private String readTemplateSyntax() throws Exception {
        this.readNextLine();
        if (!this.current.startsWith("#begin")) {
            throw new Exception("Expected #begin got " + this.current);
        }
        StringBuilder sb = new StringBuilder();
        while (!this.current.startsWith("#end")) {
            this.readNextLine();
            if (this.current.startsWith("#end")) break;
            sb.append(this.current + "\n");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

