/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.handlers;

import com.google.gwt.core.client.GWT;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.optaplanner.workbench.screens.solver.client.handlers.NewSolverHandler;
import org.optaplanner.workbench.screens.solver.client.type.SolverResourceType;
import org.optaplanner.workbench.screens.solver.service.SolverEditorService;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewSolverHandlerTest {
    @Mock
    private SolverEditorService solverService;
    @Mock
    private BusyIndicatorView busyIndicatorView;
    @Mock
    private User user;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private TranslationService translationService;
    private NewSolverHandler newSolverHandler;
    private SolverResourceType resourceType;

    @Before
    public void setUp() throws Exception {
        this.newSolverHandler = new NewSolverHandler((Caller)new CallerMock((Object)this.solverService), this.resourceType, this.busyIndicatorView, this.authorizationManager, this.sessionInfo, this.translationService);
        this.resourceType = (SolverResourceType)GWT.create(SolverResourceType.class);
    }

    @Test
    public void noPermissionToCreate() throws Exception {
        this.testPermissionToCreate(false);
    }

    @Test
    public void hasPermissionToCreate() throws Exception {
        this.testPermissionToCreate(true);
    }

    private void testPermissionToCreate(boolean hasPermission) {
        Mockito.when((Object)this.authorizationManager.authorize("planner.available", this.sessionInfo.getIdentity())).thenReturn((Object)hasPermission);
        Assert.assertEquals((Object)hasPermission, (Object)this.newSolverHandler.canCreate());
    }
}

