/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationConfigForm;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContent;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContentView;
import org.optaplanner.workbench.screens.solver.model.TerminationCompositionStyleModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigOption;

@RunWith(value=GwtMockitoTestRunner.class)
public class TerminationTreeItemContentTest {
    @Mock
    private TerminationTreeItemContentView view;
    @Mock
    private TranslationService translationService;
    @Mock
    private TerminationConfigModel terminationConfigModel;
    @Mock
    private TerminationConfigForm terminationConfigForm;
    private TerminationTreeItemContent terminationTreeItemContent;

    @Before
    public void setUp() {
        this.terminationTreeItemContent = new TerminationTreeItemContent(this.view, this.translationService);
        this.terminationTreeItemContent.setTerminationConfigForm(this.terminationConfigForm);
        this.terminationTreeItemContent.setModel(this.terminationConfigModel);
    }

    @Test
    public void presenterSet() {
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setPresenter(this.terminationTreeItemContent);
    }

    @Test
    public void removeNestedDropDownOption() {
        this.terminationTreeItemContent.removeDropDownOption(TerminationConfigOption.NESTED);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeDropDownOption((TerminationConfigOption)Matchers.any());
    }

    @Test
    public void removeNonNestedDropDownOption() {
        this.terminationTreeItemContent.removeDropDownOption(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).removeDropDownOption(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
    }

    @Test
    public void setNestedTerminationConfigOption() {
        this.terminationTreeItemContent.setTerminationConfigOption(TerminationConfigOption.NESTED);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDropDownHelpContent((String)Matchers.any());
    }

    @Test
    public void setNonNestedTerminationConfigOption() {
        this.terminationTreeItemContent.setTerminationConfigOption(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setNestedTreeItem(false);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDropDownHelpContent((String)Matchers.any());
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setFormLabelText((String)Matchers.any());
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setFormLabelHelpContent((String)Matchers.any());
    }

    @Test
    public void setTreeItem() {
        TreeItem treeItem = new TreeItem();
        this.terminationTreeItemContent.setTreeItem(treeItem);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRoot(true);
    }

    @Test
    public void removeTreeItem() {
        this.terminationTreeItemContent.setTreeItem(new TreeItem());
        this.terminationTreeItemContent.setTerminationConfigOption(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
        TreeItem rootTreeItem = (TreeItem)Mockito.mock(TreeItem.class);
        Mockito.when((Object)rootTreeItem.getChildCount()).thenReturn((Object)0);
        Mockito.when((Object)this.terminationConfigForm.getRootTreeItem()).thenReturn((Object)rootTreeItem);
        this.terminationTreeItemContent.removeTreeItem();
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel, (VerificationMode)Mockito.times((int)1))).setMillisecondsSpentLimit(null);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addDropDownOption(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
        ((TerminationConfigForm)Mockito.verify((Object)this.terminationConfigForm, (VerificationMode)Mockito.times((int)1))).displayEmptyTreeLabel(true);
    }

    @Test
    public void setExistingTimeSpentValue() {
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.MILLISECONDS_SPENT_LIMIT)).thenReturn((Object)1L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.SECONDS_SPENT_LIMIT)).thenReturn((Object)2L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.MINUTES_SPENT_LIMIT)).thenReturn((Object)3L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.HOURS_SPENT_LIMIT)).thenReturn((Object)4L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.DAYS_SPENT_LIMIT)).thenReturn((Object)5L);
        this.terminationTreeItemContent.setExistingValue((Object)1L, TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setMillisecondsSpent(Long.valueOf(1L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setSecondsSpent(Long.valueOf(2L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setMinutesSpent(Long.valueOf(3L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setHoursSpent(Long.valueOf(4L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setDaysSpent(Long.valueOf(5L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setMillisecondsSpentLimit(Long.valueOf(1L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setSecondsSpentLimit(Long.valueOf(2L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setMinutesSpentLimit(Long.valueOf(3L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setHoursSpentLimit(Long.valueOf(4L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setDaysSpentLimit(Long.valueOf(5L));
    }

    @Test
    public void setNewTimeSpentValue() {
        this.terminationTreeItemContent.setNewValue(TerminationConfigOption.MILLISECONDS_SPENT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setMillisecondsSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setMillisecondsSpentLimit(Long.valueOf(0L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setSecondsSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setSecondsSpentLimit(Long.valueOf(0L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setMinutesSpent(Long.valueOf(5L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setMinutesSpentLimit(Long.valueOf(5L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setHoursSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setHoursSpentLimit(Long.valueOf(0L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setDaysSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setDaysSpentLimit(Long.valueOf(0L));
    }

    @Test
    public void setExistingUnimprovedTimeSpentValue() {
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT)).thenReturn((Object)1L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.UNIMPROVED_SECONDS_SPENT_LIMIT)).thenReturn((Object)2L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.UNIMPROVED_MINUTES_SPENT_LIMIT)).thenReturn((Object)3L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.UNIMPROVED_HOURS_SPENT_LIMIT)).thenReturn((Object)4L);
        Mockito.when((Object)this.terminationConfigForm.getTerminationValue(this.terminationConfigModel, TerminationConfigOption.UNIMPROVED_DAYS_SPENT_LIMIT)).thenReturn((Object)5L);
        this.terminationTreeItemContent.setExistingValue((Object)1L, TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedMillisecondsSpent(Long.valueOf(1L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedSecondsSpent(Long.valueOf(2L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedMinutesSpent(Long.valueOf(3L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedHoursSpent(Long.valueOf(4L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedDaysSpent(Long.valueOf(5L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedMillisecondsSpentLimit(Long.valueOf(1L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedSecondsSpentLimit(Long.valueOf(2L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedMinutesSpentLimit(Long.valueOf(3L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedHoursSpentLimit(Long.valueOf(4L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedDaysSpentLimit(Long.valueOf(5L));
    }

    @Test
    public void setNewUnimprovedTimeSpentValue() {
        this.terminationTreeItemContent.setNewValue(TerminationConfigOption.UNIMPROVED_MILLISECONDS_SPENT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedMillisecondsSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedMillisecondsSpentLimit(Long.valueOf(0L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedSecondsSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedSecondsSpentLimit(Long.valueOf(0L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedMinutesSpent(Long.valueOf(5L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedMinutesSpentLimit(Long.valueOf(5L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedHoursSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedHoursSpentLimit(Long.valueOf(0L));
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedDaysSpent(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedDaysSpentLimit(Long.valueOf(0L));
    }

    @Test
    public void setExistingBestScoreLimitValue() {
        this.terminationTreeItemContent.setExistingValue((Object)"0", TerminationConfigOption.BEST_SCORE_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setBestScoreLimit("0");
    }

    @Test
    public void setExistingBestScoreFeasibleValue() {
        this.terminationTreeItemContent.setExistingValue((Object)true, TerminationConfigOption.BEST_SCORE_FEASIBLE);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setBestScoreFeasible(Boolean.valueOf(true));
    }

    @Test
    public void setNewBestScoreFeasibleValue() {
        this.terminationTreeItemContent.setNewValue(TerminationConfigOption.BEST_SCORE_FEASIBLE);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setBestScoreFeasible(Boolean.valueOf(true));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setBestScoreFeasible(Boolean.valueOf(true));
    }

    @Test
    public void setExistingStepCountLimitValue() {
        this.terminationTreeItemContent.setExistingValue((Object)1, TerminationConfigOption.STEP_COUNT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setStepCountLimit(Integer.valueOf(1));
    }

    @Test
    public void setNewStepCountLimitValue() {
        this.terminationTreeItemContent.setNewValue(TerminationConfigOption.STEP_COUNT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setStepCountLimit(Integer.valueOf(0));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setStepCountLimit(Integer.valueOf(0));
    }

    @Test
    public void setExistingUnimprovedStepCountLimitValue() {
        this.terminationTreeItemContent.setExistingValue((Object)1, TerminationConfigOption.UNIMPROVED_STEP_COUNT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedStepCountLimit(Integer.valueOf(1));
    }

    @Test
    public void setNewUnimprovedStepCountLimitValue() {
        this.terminationTreeItemContent.setNewValue(TerminationConfigOption.UNIMPROVED_STEP_COUNT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setUnimprovedStepCountLimit(Integer.valueOf(0));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setUnimprovedStepCountLimit(Integer.valueOf(0));
    }

    @Test
    public void setExistingScoreCalculationCountLimitValue() {
        this.terminationTreeItemContent.setExistingValue((Object)1, TerminationConfigOption.SCORE_CALCULATION_COUNT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setScoreCalculationCountLimit(Long.valueOf(1L));
    }

    @Test
    public void setNewScoreCalculationCountLimitValue() {
        this.terminationTreeItemContent.setNewValue(TerminationConfigOption.SCORE_CALCULATION_COUNT_LIMIT);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setScoreCalculationCountLimit(Long.valueOf(0L));
        ((TerminationConfigModel)Mockito.verify((Object)this.terminationConfigModel)).setScoreCalculationCountLimit(Long.valueOf(0L));
    }

    @Test
    public void setExistingTerminationCompositionStyleValue() {
        this.terminationTreeItemContent.setExistingValue((Object)TerminationCompositionStyleModel.AND, TerminationConfigOption.TERMINATION_COMPOSITION_STYLE);
        ((TerminationTreeItemContentView)Mockito.verify((Object)this.view)).setTerminationCompositionStyle(TerminationCompositionStyleModel.AND);
    }
}

