/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationConfigForm;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationConfigFormView;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContent;
import org.optaplanner.workbench.screens.solver.client.editor.TerminationTreeItemContentView;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={ElementWrapperWidget.class})
public class TerminationConfigFormTest {
    @Mock
    private TerminationConfigFormView view;
    @Mock
    private ManagedInstance<TerminationTreeItemContent> terminationTreeItemContentProvider;
    @Mock
    private TerminationTreeItemContentView terminationTreeItemContentView;
    @Mock
    private TranslationService translationService;
    private TerminationTreeItemContent terminationTreeItemContent;
    private TerminationConfigForm form;

    @Before
    public void setUp() throws Exception {
        this.form = new TerminationConfigForm(this.view, this.terminationTreeItemContentProvider);
        this.terminationTreeItemContent = new TerminationTreeItemContent(this.terminationTreeItemContentView, this.translationService);
    }

    @Test
    public void setModel() {
        TerminationConfigModel terminationConfigModel = new TerminationConfigModel();
        terminationConfigModel.setBestScoreFeasible(Boolean.TRUE);
        terminationConfigModel.setMillisecondsSpentLimit(Long.valueOf(10L));
        List<TerminationConfigModel> terminationConfigModelList = Arrays.asList(new TerminationConfigModel());
        terminationConfigModel.setTerminationConfigList(terminationConfigModelList);
        Mockito.when((Object)this.terminationTreeItemContentProvider.get()).thenReturn((Object)this.terminationTreeItemContent);
        this.form.setModel(terminationConfigModel);
        ArgumentCaptor treeItemArgumentCaptor = ArgumentCaptor.forClass(TreeItem.class);
        ((TerminationConfigFormView)Mockito.verify((Object)this.view)).initTree((TreeItem)treeItemArgumentCaptor.capture());
        TreeItem treeItem = (TreeItem)treeItemArgumentCaptor.getValue();
        Assert.assertEquals((long)3L, (long)treeItem.getChildCount());
    }
}

