/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.test.MockProvider;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.optaplanner.workbench.screens.solver.client.editor.NotificationEventMock;
import org.optaplanner.workbench.screens.solver.client.editor.SolverEditorPresenter;
import org.optaplanner.workbench.screens.solver.client.editor.SolverEditorView;
import org.optaplanner.workbench.screens.solver.client.editor.XMLViewer;
import org.optaplanner.workbench.screens.solver.client.type.SolverResourceType;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.service.SolverEditorService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Modal.class})
public class SolverEditorPresenterValidationTest {
    @Mock
    private SolverEditorView view;
    @Mock
    private SolverEditorService solverEditorService;
    @Mock
    private Command afterValidation;
    private SolverEditorPresenter presenter;

    @Before
    public void setUp() {
        SolverResourceType resourceType = (SolverResourceType)GWT.create(SolverResourceType.class);
        this.presenter = new SolverEditorPresenter(this.view, resourceType, (XMLViewer)Mockito.mock(XMLViewer.class), new NotificationEventMock(), (Caller)new CallerMock((Object)this.solverEditorService), MockProvider.getMockValidationPopup(), (TranslationService)Mockito.mock(TranslationService.class)){
            {
                this.kieView = (KieEditorWrapperView)Mockito.mock(KieEditorWrapperView.class);
                this.versionRecordManager = (VersionRecordManager)Mockito.mock(VersionRecordManager.class);
                this.alertsButtonMenuItemBuilder = (AlertsButtonMenuItemBuilder)Mockito.mock(AlertsButtonMenuItemBuilder.class);
                this.overviewWidget = (OverviewWidgetPresenter)Mockito.mock(OverviewWidgetPresenter.class);
            }
        };
    }

    @Test
    public void commandIsCalled() {
        ((SolverEditorService)Mockito.doReturn(new ArrayList()).when((Object)this.solverEditorService)).validate((Path)Matchers.any(Path.class), Matchers.any(SolverConfigModel.class));
        this.presenter.onValidate(this.afterValidation);
        ((Command)Mockito.verify((Object)this.afterValidation)).execute();
    }

    @Test
    public void callFailsAndCommandIsCalled() {
        ((SolverEditorService)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)this.solverEditorService)).validate((Path)Matchers.any(Path.class), Matchers.any(SolverConfigModel.class));
        this.presenter.onValidate(this.afterValidation);
        ((Command)Mockito.verify((Object)this.afterValidation)).execute();
    }
}

