/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.promise.Promise;
import java.util.List;
import java.util.function.Supplier;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.optaplanner.workbench.screens.solver.client.editor.NotificationEventMock;
import org.optaplanner.workbench.screens.solver.client.editor.SolverEditorPresenter;
import org.optaplanner.workbench.screens.solver.client.editor.SolverEditorView;
import org.optaplanner.workbench.screens.solver.client.editor.XMLViewer;
import org.optaplanner.workbench.screens.solver.client.resources.SolverEditorResources;
import org.optaplanner.workbench.screens.solver.client.resources.images.SolverEditorImageResources;
import org.optaplanner.workbench.screens.solver.client.type.SolverResourceType;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverConfigModel;
import org.optaplanner.workbench.screens.solver.model.SolverModelContent;
import org.optaplanner.workbench.screens.solver.model.TerminationConfigModel;
import org.optaplanner.workbench.screens.solver.service.SolverEditorService;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class SolverEditorPresenterTest {
    @GwtMock
    SolverEditorImageResources solverEditorImageResources;
    @GwtMock
    SolverEditorResources solverEditorResources;
    @Mock
    KieEditorWrapperView kieView;
    @Mock
    ObservablePath path;
    @Mock
    VersionRecordManager versionRecordManager;
    @Mock
    AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilder;
    @Mock
    private SolverEditorView view;
    private SolverEditorPresenter presenter;
    private TerminationConfigModel terminationConfigModel = new TerminationConfigModel();
    private ScoreDirectorFactoryConfigModel scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfigModel();
    private SolverConfigModel model;
    private SolverResourceType resourceType;
    private ServiceMock solverService;
    private Promises promises;

    @Before
    public void setUp() throws Exception {
        this.promises = new SyncPromises();
        this.model = new SolverConfigModel();
        this.model.setTerminationConfig(this.terminationConfigModel);
        this.model.setScoreDirectorFactoryConfig(this.scoreDirectorFactoryConfig);
        this.resourceType = (SolverResourceType)GWT.create(SolverResourceType.class);
        Mockito.when((Object)this.resourceType.getSuffix()).thenReturn((Object)"solver.xml");
        Mockito.when((Object)this.resourceType.accept((Path)this.path)).thenReturn((Object)true);
        Mockito.when((Object)this.resourceType.accept((Path)this.path)).thenReturn((Object)false);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)this.path);
        this.solverService = new ServiceMock();
        this.presenter = (SolverEditorPresenter)Mockito.spy((Object)new SolverEditorPresenter(this.view, this.resourceType, (XMLViewer)Mockito.mock(XMLViewer.class), new NotificationEventMock(), this.solverService, (ValidationPopup)Mockito.mock(ValidationPopup.class), (TranslationService)Mockito.mock(TranslationService.class)){
            {
                this.kieView = (KieEditorWrapperView)Mockito.mock(KieEditorWrapperView.class);
                this.versionRecordManager = SolverEditorPresenterTest.this.versionRecordManager;
                this.alertsButtonMenuItemBuilder = SolverEditorPresenterTest.this.alertsButtonMenuItemBuilder;
                this.overviewWidget = (OverviewWidgetPresenter)Mockito.mock(OverviewWidgetPresenter.class);
                this.promises = SolverEditorPresenterTest.this.promises;
            }

            protected Command getSaveAndRename() {
                return (Command)Mockito.mock(Command.class);
            }

            protected Promise<Void> makeMenuBar() {
                return this.promises.resolve();
            }

            protected void addSourcePage() {
            }
        });
    }

    @Test
    public void load() throws Exception {
        this.presenter.onStartup(this.path, (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((SolverEditorView)Mockito.verify((Object)this.view)).setTerminationConfigModel(this.terminationConfigModel);
        ((SolverEditorView)Mockito.verify((Object)this.view)).setScoreDirectorFactoryConfig(this.scoreDirectorFactoryConfig, (Path)this.path);
    }

    @Test
    public void testGetContentSupplier() throws Exception {
        SolverConfigModel content = (SolverConfigModel)Mockito.mock(SolverConfigModel.class);
        ((SolverEditorPresenter)Mockito.doReturn((Object)content).when((Object)this.presenter)).getModel();
        Supplier contentSupplier = this.presenter.getContentSupplier();
        Assert.assertEquals((Object)content, contentSupplier.get());
    }

    @Test
    public void testGetSaveAndRenameServiceCaller() throws Exception {
        Caller serviceCaller = this.presenter.getSaveAndRenameServiceCaller();
        Assert.assertEquals((Object)this.solverService, (Object)serviceCaller);
    }

    private class ServiceMock
    implements Caller<SolverEditorService> {
        RemoteCallback remoteCallback;
        private SolverEditorService service = new SolverEditorServiceMock();

        private ServiceMock() {
        }

        public SolverEditorService call() {
            return this.service;
        }

        public SolverEditorService call(RemoteCallback<?> remoteCallback) {
            return this.call(remoteCallback, (ErrorCallback<?>)null);
        }

        public SolverEditorService call(RemoteCallback<?> remoteCallback, ErrorCallback<?> errorCallback) {
            this.remoteCallback = remoteCallback;
            return this.call();
        }

        private class SolverEditorServiceMock
        implements SolverEditorService {
            private SolverEditorServiceMock() {
            }

            public SolverModelContent loadContent(Path path) {
                Overview overview = new Overview(){
                    {
                        this.setMetadata((Metadata)Mockito.mock(Metadata.class));
                    }
                };
                SolverModelContent content = new SolverModelContent(SolverEditorPresenterTest.this.model, overview);
                ServiceMock.this.remoteCallback.callback((Object)content);
                return null;
            }

            public List<ValidationMessage> smokeTest(Path path, SolverConfigModel config) {
                return null;
            }

            public Path copy(Path path, String newName, String comment) {
                return null;
            }

            public Path copy(Path path, String newName, Path targetDirectory, String comment) {
                return null;
            }

            public Path create(Path context, String fileName, SolverConfigModel content, String comment) {
                return null;
            }

            public void delete(Path path, String comment) {
            }

            public SolverConfigModel load(Path path) {
                return null;
            }

            public Path rename(Path path, String newName, String comment) {
                return null;
            }

            public Path save(Path path, SolverConfigModel content, Metadata metadata, String comment) {
                return null;
            }

            public List<ValidationMessage> validate(Path path, SolverConfigModel content) {
                return null;
            }

            public String toSource(Path path, SolverConfigModel model) {
                return null;
            }

            public Path saveAndRename(Path path, String newFileName, Metadata metadata, SolverConfigModel content, String comment) {
                return null;
            }
        }
    }
}

