/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.optaplanner.workbench.screens.solver.client.editor.ScoreDirectorFactoryForm;
import org.optaplanner.workbench.screens.solver.client.editor.ScoreDirectorFactoryFormView;
import org.optaplanner.workbench.screens.solver.model.ScoreDirectorFactoryConfigModel;
import org.uberfire.backend.vfs.Path;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScoreDirectorFactoryFormTest {
    @Mock
    ScoreDirectorFactoryFormView view;
    @Mock
    private Path path;
    private ScoreDirectorFactoryForm form;

    @Before
    public void setUp() throws Exception {
        this.form = new ScoreDirectorFactoryForm(this.view);
    }

    @Test
    public void setPresenter() throws Exception {
        ((ScoreDirectorFactoryFormView)Mockito.verify((Object)this.view)).setPresenter(this.form);
    }

    @Test
    public void setEmptyModel() throws Exception {
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        this.form.setModel(model, this.path);
        ((ScoreDirectorFactoryFormView)Mockito.verify((Object)this.view)).setKSession(null, this.path);
    }

    @Test
    public void setEmptyKSession() throws Exception {
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        this.form.setModel(model, this.path);
        ((ScoreDirectorFactoryFormView)Mockito.verify((Object)this.view)).setKSession(null, this.path);
    }

    @Test
    public void setModel() throws Exception {
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        model.setKSessionName("someSession");
        this.form.setModel(model, this.path);
        ((ScoreDirectorFactoryFormView)Mockito.verify((Object)this.view)).setKSession("someSession", this.path);
    }

    @Test
    public void onNameChange() throws Exception {
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        this.form.setModel(model, this.path);
        this.form.onKSessionNameChange("mySession");
        Assert.assertEquals((Object)"mySession", (Object)model.getKSessionName());
    }

    @Test
    public void onNameChangeToDefault() throws Exception {
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        this.form.setModel(model, this.path);
        this.form.onKSessionNameChange("defaultKieSession");
        Assert.assertNull((Object)model.getKSessionName());
    }

    @Test
    public void onNameChangeNull() throws Exception {
        ScoreDirectorFactoryConfigModel model = new ScoreDirectorFactoryConfigModel();
        this.form.setModel(model, this.path);
        this.form.onKSessionNameChange(null);
        Assert.assertEquals(null, (Object)model.getKSessionName());
    }
}

