/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.workbench.screens.solver.client.editor.ConstructionHeuristicForm;
import org.optaplanner.workbench.screens.solver.client.editor.LocalSearchForm;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigForm;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigFormView;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicPhaseConfigModel;
import org.optaplanner.workbench.screens.solver.model.LocalSearchPhaseConfigModel;

@RunWith(value=GwtMockitoTestRunner.class)
public class PhaseConfigFormTest {
    @Mock
    private PhaseConfigFormView view;
    @Mock
    private ManagedInstance<ConstructionHeuristicForm> constructionHeuristicFormProvider;
    @Mock
    private ManagedInstance<LocalSearchForm> localSearchFormProvider;
    @Mock
    private ConstructionHeuristicForm constructionHeuristicForm;
    @Mock
    private LocalSearchForm localSearchForm;
    @Mock
    private List model;
    private PhaseConfigForm phaseConfigForm;

    @Before
    public void setUp() {
        this.phaseConfigForm = new PhaseConfigForm(this.view, this.constructionHeuristicFormProvider, this.localSearchFormProvider);
        this.phaseConfigForm.setModel(new ArrayList());
    }

    @Test
    public void setPresenter() {
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).setPresenter(this.phaseConfigForm);
    }

    @Test
    public void setModel() {
        ArrayList<Object> phaseConfigModelList = new ArrayList<Object>();
        phaseConfigModelList.add(new ConstructionHeuristicPhaseConfigModel());
        phaseConfigModelList.add(new ConstructionHeuristicPhaseConfigModel());
        phaseConfigModelList.add(new LocalSearchPhaseConfigModel());
        phaseConfigModelList.add(new LocalSearchPhaseConfigModel());
        Mockito.when((Object)this.constructionHeuristicFormProvider.get()).thenReturn((Object)this.constructionHeuristicForm);
        Mockito.when((Object)this.localSearchFormProvider.get()).thenReturn((Object)this.localSearchForm);
        this.phaseConfigForm.setModel(phaseConfigModelList);
        ((PhaseConfigFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addConstructionHeuristic((HTMLElement)Matchers.any());
        ((PhaseConfigFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addLocalSearch((HTMLElement)Matchers.any());
    }

    @Test
    public void addConstructionHeuristic() {
        this.addConstructionHeuristic(true);
    }

    @Test
    public void addConstructionHeuristicExisting() {
        this.addConstructionHeuristic(false);
    }

    private void addConstructionHeuristic(boolean newConstructionHeuristic) {
        Mockito.when((Object)this.constructionHeuristicFormProvider.get()).thenReturn((Object)this.constructionHeuristicForm);
        if (newConstructionHeuristic) {
            this.phaseConfigForm.addConstructionHeuristic();
        } else {
            this.phaseConfigForm.addConstructionHeuristic(new ConstructionHeuristicPhaseConfigModel());
        }
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).addConstructionHeuristic((HTMLElement)Matchers.any());
    }

    @Test
    public void removeConstructionHeuristic() {
        this.phaseConfigForm.removeConstructionHeuristic(this.constructionHeuristicForm);
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).removeConstructionHeuristic(this.constructionHeuristicForm.getElement());
    }

    @Test
    public void addLocalSearch() {
        this.addLocalSearch(true);
    }

    @Test
    public void addLocalSearchExisting() {
        this.addLocalSearch(false);
    }

    private void addLocalSearch(boolean newLocalSearch) {
        Mockito.when((Object)this.localSearchFormProvider.get()).thenReturn((Object)this.localSearchForm);
        if (newLocalSearch) {
            this.phaseConfigForm.addLocalSearch();
        } else {
            this.phaseConfigForm.addLocalSearch(new LocalSearchPhaseConfigModel());
        }
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).addLocalSearch((HTMLElement)Matchers.any());
    }

    @Test
    public void removeLocalSearch() {
        this.phaseConfigForm.removeLocalSearch(this.localSearchForm);
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).removeLocalSearch(this.localSearchForm.getElement());
    }

    @Test
    public void displayEmptyPhaseConfigurationLabelConstructionHeuristic() {
        Mockito.when((Object)this.constructionHeuristicFormProvider.get()).thenReturn((Object)this.constructionHeuristicForm);
        this.phaseConfigForm.addConstructionHeuristic();
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).displayEmptyPhaseConfigurationLabel(false);
        this.phaseConfigForm.removeConstructionHeuristic(this.constructionHeuristicForm);
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).displayEmptyPhaseConfigurationLabel(true);
    }

    @Test
    public void displayEmptyPhaseConfigurationLabelLocalSearch() {
        Mockito.when((Object)this.localSearchFormProvider.get()).thenReturn((Object)this.localSearchForm);
        this.phaseConfigForm.addLocalSearch();
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).displayEmptyPhaseConfigurationLabel(false);
        this.phaseConfigForm.removeLocalSearch(this.localSearchForm);
        ((PhaseConfigFormView)Mockito.verify((Object)this.view)).displayEmptyPhaseConfigurationLabel(true);
    }
}

