/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.config.localsearch.LocalSearchType;
import org.optaplanner.workbench.screens.solver.client.editor.LocalSearchForm;
import org.optaplanner.workbench.screens.solver.client.editor.LocalSearchFormView;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigForm;
import org.optaplanner.workbench.screens.solver.model.LocalSearchPhaseConfigModel;

@RunWith(value=GwtMockitoTestRunner.class)
public class LocalSearchFormTest {
    @Mock
    private LocalSearchFormView view;
    @Mock
    private LocalSearchPhaseConfigModel model;
    @Mock
    private PhaseConfigForm phaseConfigForm;
    private LocalSearchForm localSearchForm;

    @Before
    public void setUp() {
        this.localSearchForm = new LocalSearchForm(this.view);
        this.localSearchForm.setPhaseConfigForm(this.phaseConfigForm);
    }

    @Test
    public void initLocalSearchForm() {
        ((LocalSearchFormView)Mockito.verify((Object)this.view)).setPresenter(this.localSearchForm);
        ArgumentCaptor localSearchTypeSelectOptionsCaptor = ArgumentCaptor.forClass(List.class);
        ((LocalSearchFormView)Mockito.verify((Object)this.view)).initLocalSearchTypeSelectOptions((List)localSearchTypeSelectOptionsCaptor.capture());
        List value = (List)localSearchTypeSelectOptionsCaptor.getValue();
        Assert.assertEquals((long)(LocalSearchType.values().length - 1), (long)value.size());
    }

    @Test
    public void onLocalSearchTypeSelected() {
        Mockito.when((Object)this.model.getLocalSearchType()).thenReturn((Object)LocalSearchType.LATE_ACCEPTANCE);
        this.localSearchForm.setModel(this.model);
        this.localSearchForm.onLocalSearchTypeSelected("LATE_ACCEPTANCE");
        ((LocalSearchPhaseConfigModel)Mockito.verify((Object)this.model)).setLocalSearchType(LocalSearchType.LATE_ACCEPTANCE);
    }

    @Test
    public void onLocalSearchRemoved() {
        this.localSearchForm.onLocalSearchRemoved();
        ((PhaseConfigForm)Mockito.verify((Object)this.phaseConfigForm)).removeLocalSearch(this.localSearchForm);
    }

    @Test
    public void setModelNullAttribute() {
        Mockito.when((Object)this.model.getLocalSearchType()).thenReturn(null).thenReturn((Object)LocalSearchType.LATE_ACCEPTANCE);
        this.localSearchForm.setModel(this.model);
        ((LocalSearchPhaseConfigModel)Mockito.verify((Object)this.model)).setLocalSearchType(LocalSearchType.LATE_ACCEPTANCE);
    }

    @Test
    public void setModelNonNullAttribute() {
        Mockito.when((Object)this.model.getLocalSearchType()).thenReturn((Object)LocalSearchType.LATE_ACCEPTANCE);
        this.localSearchForm.setModel(this.model);
        ((LocalSearchPhaseConfigModel)Mockito.verify((Object)this.model, (VerificationMode)Mockito.times((int)0))).setLocalSearchType(LocalSearchType.LATE_ACCEPTANCE);
    }

    @Test
    public void simulatedAnnealingIsIgnored() {
        ArgumentCaptor listArgumentCaptor = ArgumentCaptor.forClass(List.class);
        ((LocalSearchFormView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initLocalSearchTypeSelectOptions((List)listArgumentCaptor.capture());
        List value = (List)listArgumentCaptor.getValue();
        boolean simulatedAnnealingPresent = value.stream().anyMatch(p -> LocalSearchType.SIMULATED_ANNEALING.toString().equals(p.getK2()));
        Assert.assertFalse((boolean)simulatedAnnealingPresent);
    }
}

