/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.workbench.screens.solver.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.config.constructionheuristic.ConstructionHeuristicType;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySorterManner;
import org.optaplanner.workbench.screens.solver.client.editor.ConstructionHeuristicForm;
import org.optaplanner.workbench.screens.solver.client.editor.ConstructionHeuristicFormView;
import org.optaplanner.workbench.screens.solver.client.editor.PhaseConfigForm;
import org.optaplanner.workbench.screens.solver.model.ConstructionHeuristicPhaseConfigModel;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConstructionHeuristicFormTest {
    @Mock
    private ConstructionHeuristicFormView view;
    @Mock
    private ConstructionHeuristicPhaseConfigModel model;
    @Mock
    private PhaseConfigForm phaseConfigForm;
    private ConstructionHeuristicForm constructionHeuristicForm;

    @Before
    public void setUp() {
        this.constructionHeuristicForm = new ConstructionHeuristicForm(this.view);
        this.constructionHeuristicForm.setPhaseConfigForm(this.phaseConfigForm);
    }

    @Test
    public void initConstructionHeuristicForm() {
        ((ConstructionHeuristicFormView)Mockito.verify((Object)this.view)).setPresenter(this.constructionHeuristicForm);
        ArgumentCaptor constructionHeuristicTypeSelectOptionsCaptor = ArgumentCaptor.forClass(List.class);
        ((ConstructionHeuristicFormView)Mockito.verify((Object)this.view)).initConstructionHeuristicTypeSelectOptions((List)constructionHeuristicTypeSelectOptionsCaptor.capture());
        List value = (List)constructionHeuristicTypeSelectOptionsCaptor.getValue();
        Assert.assertEquals((long)ConstructionHeuristicType.values().length, (long)value.size());
        ((ConstructionHeuristicFormView)Mockito.verify((Object)this.view)).initEntitySorterMannerSelectOptions((List)constructionHeuristicTypeSelectOptionsCaptor.capture());
        value = (List)constructionHeuristicTypeSelectOptionsCaptor.getValue();
        Assert.assertEquals((long)EntitySorterManner.values().length, (long)value.size());
    }

    @Test
    public void onConstructionHeuristicTypeSelected() {
        Mockito.when((Object)this.model.getConstructionHeuristicType()).thenReturn((Object)ConstructionHeuristicType.FIRST_FIT_DECREASING);
        Mockito.when((Object)this.model.getEntitySorterManner()).thenReturn((Object)EntitySorterManner.DECREASING_DIFFICULTY);
        this.constructionHeuristicForm.setModel(this.model);
        this.constructionHeuristicForm.onConstructionHeuristicTypeSelected("FIRST_FIT");
        ((ConstructionHeuristicPhaseConfigModel)Mockito.verify((Object)this.model)).setConstructionHeuristicType(ConstructionHeuristicType.FIRST_FIT);
    }

    @Test
    public void onEntitySorterMannerSelected() {
        Mockito.when((Object)this.model.getConstructionHeuristicType()).thenReturn((Object)ConstructionHeuristicType.FIRST_FIT_DECREASING);
        Mockito.when((Object)this.model.getEntitySorterManner()).thenReturn((Object)EntitySorterManner.DECREASING_DIFFICULTY_IF_AVAILABLE);
        this.constructionHeuristicForm.setModel(this.model);
        this.constructionHeuristicForm.onEntitySorterMannerSelected("DECREASING_DIFFICULTY");
        ((ConstructionHeuristicPhaseConfigModel)Mockito.verify((Object)this.model)).setEntitySorterManner(EntitySorterManner.DECREASING_DIFFICULTY);
    }

    @Test
    public void onConstructionHeuristicRemoved() {
        this.constructionHeuristicForm.onConstructionHeuristicRemoved();
        ((PhaseConfigForm)Mockito.verify((Object)this.phaseConfigForm)).removeConstructionHeuristic(this.constructionHeuristicForm);
    }

    @Test
    public void setModelNullAttribute() {
        Mockito.when((Object)this.model.getConstructionHeuristicType()).thenReturn(null).thenReturn((Object)ConstructionHeuristicType.FIRST_FIT_DECREASING);
        Mockito.when((Object)this.model.getEntitySorterManner()).thenReturn(null).thenReturn((Object)EntitySorterManner.DECREASING_DIFFICULTY_IF_AVAILABLE);
        this.constructionHeuristicForm.setModel(this.model);
        ((ConstructionHeuristicPhaseConfigModel)Mockito.verify((Object)this.model)).setConstructionHeuristicType(ConstructionHeuristicType.FIRST_FIT);
        ((ConstructionHeuristicPhaseConfigModel)Mockito.verify((Object)this.model)).setEntitySorterManner(EntitySorterManner.NONE);
    }

    @Test
    public void setModelNonNullAttribute() {
        Mockito.when((Object)this.model.getConstructionHeuristicType()).thenReturn((Object)ConstructionHeuristicType.FIRST_FIT_DECREASING);
        Mockito.when((Object)this.model.getEntitySorterManner()).thenReturn((Object)EntitySorterManner.DECREASING_DIFFICULTY_IF_AVAILABLE);
        this.constructionHeuristicForm.setModel(this.model);
        ((ConstructionHeuristicPhaseConfigModel)Mockito.verify((Object)this.model, (VerificationMode)Mockito.times((int)0))).setConstructionHeuristicType(ConstructionHeuristicType.FIRST_FIT);
        ((ConstructionHeuristicPhaseConfigModel)Mockito.verify((Object)this.model, (VerificationMode)Mockito.times((int)0))).setEntitySorterManner(EntitySorterManner.NONE);
    }
}

