/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.verifier;

import io.quarkus.test.QuarkusUnitTest;
import jakarta.inject.Inject;
import java.util.Arrays;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.impl.testutil.DisabledInProductization;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaplanner.test.impl.score.stream.DefaultConstraintVerifier;

@DisabledInProductization
class OptaPlannerConstraintVerifierBavetStreamImplTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class})).addAsResource("org/optaplanner/quarkus/verifier/bavetSolverConfig.xml", "solverConfig.xml"));
    @Inject
    ConstraintVerifier<TestdataQuarkusConstraintProvider, TestdataQuarkusSolution> constraintVerifier;

    OptaPlannerConstraintVerifierBavetStreamImplTest() {
    }

    @Test
    void constraintVerifierBavetStreamImpl() {
        Assertions.assertEquals((Object)ConstraintStreamImplType.BAVET, (Object)((DefaultConstraintVerifier)this.constraintVerifier).getConstraintStreamImplType());
        TestdataQuarkusSolution solution = new TestdataQuarkusSolution();
        TestdataQuarkusEntity entityA = new TestdataQuarkusEntity();
        TestdataQuarkusEntity entityB = new TestdataQuarkusEntity();
        entityA.setValue("A");
        entityB.setValue("A");
        solution.setEntityList(Arrays.asList(entityA, entityB));
        solution.setValueList(Arrays.asList("A", "B"));
        this.constraintVerifier.verifyThat().givenSolution((Object)solution).scores((Score)SimpleScore.of((int)-2));
        entityB.setValue("B");
        this.constraintVerifier.verifyThat().givenSolution((Object)solution).scores((Score)SimpleScore.ZERO);
    }
}

