/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.io.jaxb.SolverConfigIO;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactoryService;
import org.optaplanner.core.impl.score.stream.JoinerService;
import org.optaplanner.quarkus.OptaPlannerRecorder;
import org.optaplanner.quarkus.bean.DefaultOptaPlannerBeanProvider;
import org.optaplanner.quarkus.bean.UnavailableOptaPlannerBeanProvider;
import org.optaplanner.quarkus.config.OptaPlannerRuntimeConfig;
import org.optaplanner.quarkus.deployment.DetermineIfNativeBuildItem;
import org.optaplanner.quarkus.deployment.DotNames;
import org.optaplanner.quarkus.deployment.GeneratedGizmoClasses;
import org.optaplanner.quarkus.deployment.GizmoMemberAccessorEntityEnhancer;
import org.optaplanner.quarkus.deployment.SolverConfigBuildItem;
import org.optaplanner.quarkus.deployment.config.OptaPlannerBuildTimeConfig;
import org.optaplanner.quarkus.devui.OptaPlannerDevUIPropertiesSupplier;
import org.optaplanner.quarkus.gizmo.OptaPlannerGizmoBeanFactory;

class OptaPlannerProcessor {
    private static final Logger log = Logger.getLogger((String)OptaPlannerProcessor.class.getName());
    OptaPlannerBuildTimeConfig optaPlannerBuildTimeConfig;

    OptaPlannerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("optaplanner");
    }

    @BuildStep
    void registerSpi(BuildProducer<ServiceProviderBuildItem> services) {
        Stream.of(ScoreDirectorFactoryService.class, JoinerService.class).forEach(service -> OptaPlannerProcessor.registerSpi(service, services));
    }

    private static void registerSpi(Class<?> serviceClass, BuildProducer<ServiceProviderBuildItem> services) {
        String serviceName = serviceClass.getName();
        String service = "META-INF/services/" + serviceName;
        try {
            Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)service);
            services.produce((BuildItem)new ServiceProviderBuildItem(serviceName, implementations.toArray(new String[0])));
        }
        catch (IOException e) {
            throw new IllegalStateException("Impossible state: Failed registering service " + serviceClass.getCanonicalName(), e);
        }
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchSolverConfigXml() {
        String solverConfigXML = this.optaPlannerBuildTimeConfig.solverConfigXml.orElse("solverConfig.xml");
        return new HotDeploymentWatchedFileBuildItem(solverConfigXML);
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchConstraintsDrl() {
        String constraintsDrl = this.optaPlannerBuildTimeConfig.scoreDrl.orElse("constraints.drl");
        return new HotDeploymentWatchedFileBuildItem(constraintsDrl);
    }

    @BuildStep
    IndexDependencyBuildItem indexDependencyBuildItem() {
        return new IndexDependencyBuildItem("org.optaplanner", "optaplanner-core-impl");
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void makeGizmoBeanFactoryUnremovable(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{OptaPlannerGizmoBeanFactory.class}));
    }

    @BuildStep(onlyIfNot={NativeBuild.class})
    DetermineIfNativeBuildItem ifNotNativeBuild() {
        return new DetermineIfNativeBuildItem(false);
    }

    @BuildStep(onlyIf={NativeBuild.class})
    DetermineIfNativeBuildItem ifNativeBuild() {
        return new DetermineIfNativeBuildItem(true);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRuntimeTemplateInfoBuildItem getSolverConfig(SolverConfigBuildItem solverConfigBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        SolverConfig solverConfig = solverConfigBuildItem.getSolverConfig();
        if (solverConfig != null) {
            StringWriter effectiveSolverConfigWriter = new StringWriter();
            SolverConfigIO solverConfigIO = new SolverConfigIO();
            solverConfigIO.write(solverConfig, (Writer)effectiveSolverConfigWriter);
            return new DevConsoleRuntimeTemplateInfoBuildItem("solverConfigProperties", (Supplier)new OptaPlannerDevUIPropertiesSupplier(effectiveSolverConfigWriter.toString()), this.getClass(), curateOutcomeBuildItem);
        }
        return new DevConsoleRuntimeTemplateInfoBuildItem("solverConfigProperties", (Supplier)new OptaPlannerDevUIPropertiesSupplier(), this.getClass(), curateOutcomeBuildItem);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void makeSolverFactoryUnremovableInDevMode(BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{SolverFactory.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SolverConfigBuildItem recordAndRegisterBeans(OptaPlannerRecorder recorder, RecorderContext recorderContext, DetermineIfNativeBuildItem determineIfNative, CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        SolverConfig solverConfig;
        IndexView indexView = combinedIndex.getIndex();
        if (indexView.getAnnotations(DotNames.PLANNING_SOLUTION).isEmpty() && indexView.getAnnotations(DotNames.PLANNING_ENTITY).isEmpty()) {
            log.warn((Object)("Skipping OptaPlanner extension because there are no @" + PlanningSolution.class.getSimpleName() + " or @" + PlanningEntity.class.getSimpleName() + " annotated classes.\nIf your domain classes are located in a dependency of this project, maybe try generating the Jandex index by using the jandex-maven-plugin in that dependency, or by addingapplication.properties entries (quarkus.index-dependency.<name>.group-id and quarkus.index-dependency.<name>.artifact-id)."));
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{UnavailableOptaPlannerBeanProvider.class}));
            return new SolverConfigBuildItem(null);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.optaPlannerBuildTimeConfig.solverConfigXml.isPresent()) {
            String solverConfigXML = this.optaPlannerBuildTimeConfig.solverConfigXml.get();
            if (classLoader.getResource(solverConfigXML) == null) {
                throw new ConfigurationException("Invalid quarkus.optaplanner.solverConfigXML property (" + solverConfigXML + "): that classpath resource does not exist.");
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverConfigXML);
        } else {
            solverConfig = classLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml") : new SolverConfig();
        }
        this.applySolverProperties(indexView, solverConfig);
        this.assertNoMemberAnnotationWithoutClassAnnotation(indexView);
        this.assertDrlDisabledInNative(solverConfig, determineIfNative);
        if (solverConfig.getSolutionClass() != null) {
            Type jandexType = Type.create((DotName)DotName.createSimple((String)solverConfig.getSolutionClass().getName()), (Type.Kind)Type.Kind.CLASS);
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(jandexType).ignoreTypePredicate(dotName -> ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName) || dotName.toString().startsWith("org.optaplanner.api") || dotName.toString().startsWith("org.optaplanner.config") || dotName.toString().startsWith("org.optaplanner.impl")).build());
        }
        if (determineIfNative.isNative()) {
            if (solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null && solverConfig.getScoreDirectorFactoryConfig().getConstraintStreamImplType() != ConstraintStreamImplType.BAVET) {
                this.disableANC(solverConfig);
            } else if (solverConfig.getScoreDirectorFactoryConfig().getScoreDrlList() != null || solverConfig.getScoreDirectorFactoryConfig().getScoreDrlFileList() == null) {
                this.disableANC(solverConfig);
            }
        }
        LinkedHashSet reflectiveClassSet = new LinkedHashSet();
        this.registerClassesFromAnnotations(indexView, reflectiveClassSet);
        this.registerCustomClassesFromSolverConfig(solverConfig, reflectiveClassSet);
        this.generateConstraintVerifier(solverConfig, syntheticBeanBuildItemBuildProducer);
        GeneratedGizmoClasses generatedGizmoClasses = this.generateDomainAccessors(solverConfig, indexView, generatedBeans, generatedClasses, transformers, reflectiveClassSet);
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverConfigSupplier(solverConfig, GizmoMemberAccessorEntityEnhancer.getGeneratedGizmoMemberAccessorMap(recorderContext, generatedGizmoClasses.generatedGizmoMemberAccessorClassSet), GizmoMemberAccessorEntityEnhancer.getGeneratedSolutionClonerMap(recorderContext, generatedGizmoClasses.generatedGizmoSolutionClonerClassSet))).done());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManagerConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverManagerConfig(solverManagerConfig)).done());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultOptaPlannerBeanProvider.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{OptaPlannerRuntimeConfig.class}));
        return new SolverConfigBuildItem(solverConfig);
    }

    private void disableANC(SolverConfig solverConfig) {
        if (solverConfig.getScoreDirectorFactoryConfig().getDroolsAlphaNetworkCompilationEnabled() != null && solverConfig.getScoreDirectorFactoryConfig().getDroolsAlphaNetworkCompilationEnabled().booleanValue()) {
            log.warn((Object)"Disabling Drools Alpha Network Compiler since this is a native build.");
        }
        solverConfig.getScoreDirectorFactoryConfig().setDroolsAlphaNetworkCompilationEnabled(Boolean.valueOf(false));
    }

    private void generateConstraintVerifier(SolverConfig solverConfig, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        String constraintVerifierClassName = DotNames.CONSTRAINT_VERIFIER.toString();
        if (solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass() != null && this.isClassDefined(constraintVerifierClassName)) {
            Class constraintProviderClass = solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass();
            Class planningSolutionClass = solverConfig.getSolutionClass();
            List planningEntityClasses = solverConfig.getEntityClassList();
            ConstraintStreamImplType constraintStreamImplType = solverConfig.getScoreDirectorFactoryConfig().getConstraintStreamImplType();
            Boolean droolsAlphaNetworkCompilationEnabled = solverConfig.getScoreDirectorFactoryConfig().isDroolsAlphaNetworkCompilationEnabled();
            syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((DotName)DotNames.CONSTRAINT_VERIFIER).scope(Singleton.class)).creator(methodCreator -> {
                ResultHandle constraintProviderResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Class)constraintProviderClass, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle planningSolutionClassResultHandle = methodCreator.loadClass(planningSolutionClass);
                ResultHandle planningEntityClassesResultHandle = methodCreator.newArray(Class.class, planningEntityClasses.size());
                for (int i = 0; i < planningEntityClasses.size(); ++i) {
                    ResultHandle planningEntityClassResultHandle = methodCreator.loadClass((Class)planningEntityClasses.get(i));
                    methodCreator.writeArrayValue(planningEntityClassesResultHandle, i, planningEntityClassResultHandle);
                }
                ResultHandle solutionDescriptorResultHandle = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(SolutionDescriptor.class, (String)"buildSolutionDescriptor", SolutionDescriptor.class, (Class[])new Class[]{Class.class, Class[].class}), new ResultHandle[]{planningSolutionClassResultHandle, planningEntityClassesResultHandle});
                ResultHandle constraintVerifierResultHandle = methodCreator.newInstance(MethodDescriptor.ofConstructor((Object)"org.optaplanner.test.impl.score.stream.DefaultConstraintVerifier", (Object[])new Object[]{ConstraintProvider.class, SolutionDescriptor.class}), new ResultHandle[]{constraintProviderResultHandle, solutionDescriptorResultHandle});
                if (constraintStreamImplType != null) {
                    constraintVerifierResultHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)constraintVerifierClassName, (String)"withConstraintStreamImplType", (Object)constraintVerifierClassName, (Object[])new Object[]{ConstraintStreamImplType.class}), constraintVerifierResultHandle, new ResultHandle[]{methodCreator.load((Enum)constraintStreamImplType)});
                }
                if (droolsAlphaNetworkCompilationEnabled != null) {
                    constraintVerifierResultHandle = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)constraintVerifierClassName, (String)"withDroolsAlphaNetworkCompilationEnabled", (Object)constraintVerifierClassName, (Object[])new Object[]{Boolean.TYPE}), constraintVerifierResultHandle, new ResultHandle[]{methodCreator.load(droolsAlphaNetworkCompilationEnabled.booleanValue())});
                }
                methodCreator.returnValue(constraintVerifierResultHandle);
            })).addType((Type)ParameterizedType.create((DotName)DotNames.CONSTRAINT_VERIFIER, (Type[])new Type[]{Type.create((DotName)DotName.createSimple((String)constraintProviderClass.getName()), (Type.Kind)Type.Kind.CLASS), Type.create((DotName)DotName.createSimple((String)planningSolutionClass.getName()), (Type.Kind)Type.Kind.CLASS)}, null))).forceApplicationClass()).defaultBean()).done());
        }
    }

    private void applySolverProperties(IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findSolutionClass(indexView));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(indexView));
        }
        this.applyScoreDirectorFactoryProperties(indexView, solverConfig);
        this.optaPlannerBuildTimeConfig.solver.environmentMode.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setEnvironmentMode(arg_0));
        this.optaPlannerBuildTimeConfig.solver.daemon.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDaemon(arg_0));
        this.optaPlannerBuildTimeConfig.solver.domainAccessType.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setDomainAccessType(arg_0));
        this.optaPlannerBuildTimeConfig.solver.constraintStreamImplType.ifPresent(arg_0 -> ((SolverConfig)solverConfig).withConstraintStreamImplType(arg_0));
        if (solverConfig.getDomainAccessType() == null) {
            solverConfig.setDomainAccessType(DomainAccessType.GIZMO);
        }
    }

    private Class<?> findSolutionClass(IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
        if (annotationInstances.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        AnnotationTarget solutionTarget = ((AnnotationInstance)annotationInstances.iterator().next()).target();
        if (solutionTarget.kind() != AnnotationTarget.Kind.CLASS) {
            throw new IllegalStateException("A target (" + solutionTarget + ") with a @" + PlanningSolution.class.getSimpleName() + " must be a class.");
        }
        return this.convertClassInfoToClass(solutionTarget.asClass());
    }

    private List<Class<?>> findEntityClassList(IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_ENTITY);
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        List targetList = annotationInstances.stream().map(AnnotationInstance::target).collect(Collectors.toList());
        if (targetList.stream().anyMatch(target -> target.kind() != AnnotationTarget.Kind.CLASS)) {
            throw new IllegalStateException("All targets (" + targetList + ") with a @" + PlanningEntity.class.getSimpleName() + " must be a class.");
        }
        return targetList.stream().map(target -> this.convertClassInfoToClass(target.asClass())).collect(Collectors.toList());
    }

    private void assertNoMemberAnnotationWithoutClassAnnotation(IndexView indexView) {
        HashSet optaplannerFieldAnnotations = new HashSet();
        for (DotName annotationName : DotNames.PLANNING_ENTITY_FIELD_ANNOTATIONS) {
            optaplannerFieldAnnotations.addAll(indexView.getAnnotations(annotationName));
        }
        for (AnnotationInstance annotationInstance : optaplannerFieldAnnotations) {
            ClassInfo declaringClass;
            String prefix;
            AnnotationTarget annotationTarget = annotationInstance.target();
            switch (annotationTarget.kind()) {
                case FIELD: {
                    prefix = "The field (" + annotationTarget.asField().name() + ") ";
                    declaringClass = annotationTarget.asField().declaringClass();
                    break;
                }
                case METHOD: {
                    prefix = "The method (" + annotationTarget.asMethod().name() + ") ";
                    declaringClass = annotationTarget.asMethod().declaringClass();
                    break;
                }
                default: {
                    throw new IllegalStateException("Member annotation @" + annotationInstance.name().withoutPackagePrefix() + " is on (" + annotationTarget + "), which is an invalid target type (" + annotationTarget.kind() + ") for @" + annotationInstance.name().withoutPackagePrefix() + ".");
                }
            }
            if (declaringClass.annotationsMap().containsKey(DotNames.PLANNING_ENTITY)) continue;
            throw new IllegalStateException(prefix + "with a @" + annotationInstance.name().withoutPackagePrefix() + " annotation is in a class (" + declaringClass.name() + ") that does not have a @" + PlanningEntity.class.getSimpleName() + " annotation.\nMaybe add a @" + PlanningEntity.class.getSimpleName() + " annotation on the class (" + declaringClass.name() + ").");
        }
    }

    private void assertDrlDisabledInNative(SolverConfig solverConfig, DetermineIfNativeBuildItem determineIfNative) {
        if (!determineIfNative.isNative()) {
            return;
        }
        if (solverConfig.getScoreDirectorFactoryConfig().getScoreDrlList() == null) {
            return;
        }
        throw new IllegalStateException("Score DRL is not supported during native build.\nConsider switching to Constraint Streams.");
    }

    private void registerClassesFromAnnotations(IndexView indexView, Set<Class<?>> reflectiveClassSet) {
        for (DotNames.BeanDefiningAnnotations beanDefiningAnnotation : DotNames.BeanDefiningAnnotations.values()) {
            for (AnnotationInstance annotationInstance : indexView.getAnnotations(beanDefiningAnnotation.getAnnotationDotName())) {
                for (String parameterName : beanDefiningAnnotation.getParameterNames()) {
                    AnnotationValue value = annotationInstance.value(parameterName);
                    if (value == null) continue;
                    Type type = value.asClass();
                    try {
                        Class<?> beanClass = Class.forName(type.name().toString(), false, Thread.currentThread().getContextClassLoader());
                        reflectiveClassSet.add(beanClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Cannot find bean class (" + type.name() + ") referenced in annotation (" + annotationInstance + ").");
                    }
                }
            }
        }
    }

    protected void applyScoreDirectorFactoryProperties(IndexView indexView, SolverConfig solverConfig) {
        Optional<String> constraintsDrlFromProperty = this.constraintsDrl();
        Optional<String> defaultConstraintsDrl = this.defaultConstraintsDrl();
        Optional<String> effectiveConstraintsDrl = constraintsDrlFromProperty.or(() -> defaultConstraintsDrl);
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = this.defaultScoreDirectoryFactoryConfig(indexView, effectiveConstraintsDrl);
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        } else {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
            if (constraintsDrlFromProperty.isPresent()) {
                scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(constraintsDrlFromProperty.get()));
            } else if (scoreDirectorFactoryConfig.getScoreDrlList() == null) {
                defaultConstraintsDrl.ifPresent(resolvedConstraintsDrl -> scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(resolvedConstraintsDrl)));
            }
        }
        if (solverConfig.getScoreDirectorFactoryConfig().getKieBaseConfigurationProperties() != null) {
            throw new IllegalStateException("Using kieBaseConfigurationProperties (" + solverConfig.getScoreDirectorFactoryConfig().getKieBaseConfigurationProperties() + ") in Quarkus, which is unsupported.");
        }
    }

    private boolean isClassDefined(String className) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected Optional<String> constraintsDrl() {
        if (this.optaPlannerBuildTimeConfig.scoreDrl.isPresent()) {
            String constraintsDrl = this.optaPlannerBuildTimeConfig.scoreDrl.get();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader.getResource(constraintsDrl) == null) {
                throw new IllegalStateException("Invalid quarkus.optaplanner.score-drl property (" + constraintsDrl + "): that classpath resource does not exist.");
            }
        }
        return this.optaPlannerBuildTimeConfig.scoreDrl;
    }

    protected Optional<String> defaultConstraintsDrl() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResource("constraints.drl") != null ? Optional.of("constraints.drl") : Optional.empty();
    }

    private ScoreDirectorFactoryConfig defaultScoreDirectoryFactoryConfig(IndexView indexView, Optional<String> constrainsDrl) {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findImplementingClass(DotNames.EASY_SCORE_CALCULATOR, indexView));
        scoreDirectorFactoryConfig.setConstraintProviderClass(this.findImplementingClass(DotNames.CONSTRAINT_PROVIDER, indexView));
        scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findImplementingClass(DotNames.INCREMENTAL_SCORE_CALCULATOR, indexView));
        constrainsDrl.ifPresent(value -> scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList(value)));
        if (scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getConstraintProviderClass() == null && scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getScoreDrlList() == null) {
            throw new IllegalStateException("No classes found that implement " + EasyScoreCalculator.class.getSimpleName() + ", " + ConstraintProvider.class.getSimpleName() + " or " + IncrementalScoreCalculator.class.getSimpleName() + ".\nNeither was a property quarkus.optaplanner.score-drl defined, nor a constraints.drl resource found.\n");
        }
        return scoreDirectorFactoryConfig;
    }

    private <T> Class<? extends T> findImplementingClass(DotName targetDotName, IndexView indexView) {
        Collection classInfos = indexView.getAllKnownImplementors(targetDotName);
        if (classInfos.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertClassInfosToString(classInfos) + ") found that implement the interface " + targetDotName + ".");
        }
        if (classInfos.isEmpty()) {
            return null;
        }
        ClassInfo classInfo = (ClassInfo)classInfos.iterator().next();
        return this.convertClassInfoToClass(classInfo);
    }

    private String convertAnnotationInstancesToString(Collection<AnnotationInstance> annotationInstances) {
        return "[" + annotationInstances.stream().map(instance -> instance.target().toString()).collect(Collectors.joining(", ")) + "]";
    }

    private String convertClassInfosToString(Collection<ClassInfo> classInfos) {
        return "[" + classInfos.stream().map(instance -> instance.name().toString()).collect(Collectors.joining(", ")) + "]";
    }

    private <T> Class<? extends T> convertClassInfoToClass(ClassInfo classInfo) {
        String className = classInfo.name().toString();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + className + ") cannot be created during deployment.", e);
        }
    }

    private GeneratedGizmoClasses generateDomainAccessors(SolverConfig solverConfig, IndexView indexView, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<BytecodeTransformerBuildItem> transformers, Set<Class<?>> reflectiveClassSet) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        HashSet<String> generatedMemberAccessorsClassNameSet = new HashSet<String>();
        HashSet<String> gizmoSolutionClonerClassNameSet = new HashSet<String>();
        if (solverConfig.getDomainAccessType() == DomainAccessType.GIZMO) {
            ArrayList<AnnotationInstance> membersToGeneratedAccessorsFor = new ArrayList<AnnotationInstance>();
            for (DotName dotName : DotNames.GIZMO_MEMBER_ACCESSOR_ANNOTATIONS) {
                membersToGeneratedAccessorsFor.addAll(indexView.getAnnotations(dotName));
            }
            membersToGeneratedAccessorsFor.removeIf(this::shouldIgnoreMember);
            block9: for (AnnotationInstance annotatedMember : membersToGeneratedAccessorsFor) {
                switch (annotatedMember.target().kind()) {
                    case FIELD: {
                        FieldInfo fieldInfo = annotatedMember.target().asField();
                        ClassInfo classInfo = fieldInfo.declaringClass();
                        try {
                            generatedMemberAccessorsClassNameSet.add(GizmoMemberAccessorEntityEnhancer.generateFieldAccessor(annotatedMember, (ClassOutput)classOutput, classInfo, fieldInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchFieldException e) {
                            throw new IllegalStateException("Fail to generate member accessor for field (" + fieldInfo.name() + ") of the class( " + classInfo.name().toString() + ").", e);
                        }
                    }
                    case METHOD: {
                        MethodInfo methodInfo = annotatedMember.target().asMethod();
                        ClassInfo classInfo = methodInfo.declaringClass();
                        try {
                            generatedMemberAccessorsClassNameSet.add(GizmoMemberAccessorEntityEnhancer.generateMethodAccessor(annotatedMember, (ClassOutput)classOutput, classInfo, methodInfo, transformers));
                            continue block9;
                        }
                        catch (ClassNotFoundException | NoSuchMethodException e) {
                            throw new IllegalStateException("Failed to generate member accessor for the method (" + methodInfo.name() + ") of the class (" + classInfo.name() + ").", e);
                        }
                    }
                }
                throw new IllegalStateException("The member (" + annotatedMember + ") is not on a field or method.");
            }
            SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor((DomainAccessType)DomainAccessType.REFLECTION, (Class)solverConfig.getSolutionClass(), null, null, (List)solverConfig.getEntityClassList());
            gizmoSolutionClonerClassNameSet.add(GizmoMemberAccessorEntityEnhancer.generateSolutionCloner(solutionDescriptor, (ClassOutput)classOutput, indexView, transformers));
        }
        GizmoMemberAccessorEntityEnhancer.generateGizmoBeanFactory((ClassOutput)beanClassOutput, reflectiveClassSet, transformers);
        return new GeneratedGizmoClasses(generatedMemberAccessorsClassNameSet, gizmoSolutionClonerClassNameSet);
    }

    private boolean shouldIgnoreMember(AnnotationInstance annotationInstance) {
        switch (annotationInstance.target().kind()) {
            case FIELD: {
                return (annotationInstance.target().asField().flags() & 8) != 0;
            }
            case METHOD: {
                return (annotationInstance.target().asMethod().flags() & 8) != 0;
            }
        }
        throw new IllegalArgumentException("Annotation (" + annotationInstance.name() + ") can only be applied to methods and fields.");
    }

    private void registerCustomClassesFromSolverConfig(SolverConfig solverConfig, Set<Class<?>> reflectiveClassSet) {
        solverConfig.visitReferencedClasses(clazz -> {
            if (clazz != null) {
                reflectiveClassSet.add((Class<?>)clazz);
            }
        });
    }
}

