/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.drools.core.io.impl.ClassPathResource;
import org.drools.modelcompiler.ExecutableModelProject;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.utils.KieHelper;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.kie.kogito.rules.RuleConfig;
import org.optaplanner.core.config.util.ConfigUtils;

@ApplicationScoped
public class KieRuntimeBuilderMock
implements KieRuntimeBuilder {
    public KieBase getKieBase() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        KieHelper kieHelper = new KieHelper(new KnowledgeBuilderOption[]{PropertySpecificOption.ALLOWED}).setClassLoader(classLoader);
        List<String> scoreDrlList = Thread.currentThread().getContextClassLoader().getResource("constraints.drl") != null ? Collections.singletonList("constraints.drl") : Collections.singletonList("customConstraints.drl");
        if (!ConfigUtils.isEmptyCollection(scoreDrlList)) {
            for (String scoreDrl : scoreDrlList) {
                if (scoreDrl == null) {
                    throw new IllegalArgumentException("The scoreDrl (" + scoreDrl + ") cannot be null.");
                }
                kieHelper.addResource((Resource)new ClassPathResource(scoreDrl, classLoader));
            }
        }
        try {
            return kieHelper.build(ExecutableModelProject.class, new KieBaseOption[]{KieBaseMutabilityOption.DISABLED});
        }
        catch (Exception ex) {
            throw new IllegalStateException("There is an error in a scoreDrl or scoreDrlFile.", ex);
        }
    }

    public KieBase getKieBase(String s) {
        return null;
    }

    public KieSession newKieSession() {
        return null;
    }

    public KieSession newKieSession(String s) {
        return null;
    }

    public KieSession newKieSession(String s, RuleConfig ruleConfig) {
        return null;
    }
}

