/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.quarkus.config.OptaPlannerRuntimeConfig;
import org.optaplanner.quarkus.config.SolverRuntimeConfig;
import org.optaplanner.quarkus.config.TerminationRuntimeConfig;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

public class OptaPlannerProcessorOverrideTerminationAtRuntimeTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0").overrideConfigKey("quarkus.arc.selected-alternatives", "MyOptaPlannerRuntimeConfig").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class, MyOptaPlannerRuntimeConfig.class}));
    @Inject
    SolverConfig solverConfig;
    @Inject
    SolverFactory<TestdataQuarkusSolution> solverFactory;

    @Test
    public void bestScoreLimitShouldBeOverwritten() {
        Assertions.assertNotNull((Object)this.solverConfig);
        Assertions.assertEquals((Object)"7", (Object)this.solverConfig.getTerminationConfig().getBestScoreLimit());
    }

    @Alternative
    @ApplicationScoped
    public static class MyOptaPlannerRuntimeConfig
    extends OptaPlannerRuntimeConfig {
        public MyOptaPlannerRuntimeConfig() {
            this.solver = new SolverRuntimeConfig();
            this.solver.termination = new TerminationRuntimeConfig();
            this.solver.termination.bestScoreLimit = Optional.of("7");
            this.solver.termination.spentLimit = Optional.empty();
            this.solver.termination.unimprovedSpentLimit = Optional.empty();
        }
    }
}

