/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.quarkus.testdata.interfaceentity.domain.TestdataInterfaceEntity;
import org.optaplanner.quarkus.testdata.interfaceentity.domain.TestdataInterfaceEntityImplementation;
import org.optaplanner.quarkus.testdata.interfaceentity.domain.TestdataInterfaceEntitySolution;

class OptaPlannerProcessorInterfaceEntityTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackages(true, new String[]{"org.optaplanner.quarkus.testdata.interfaceentity"}));
    @Inject
    SolverFactory<TestdataInterfaceEntitySolution> solverFactory;

    OptaPlannerProcessorInterfaceEntityTest() {
    }

    @Test
    void buildSolver() {
        TestdataInterfaceEntitySolution problem = new TestdataInterfaceEntitySolution();
        List<TestdataInterfaceEntity> entityList = IntStream.range(1, 3).mapToObj(i -> new TestdataInterfaceEntityImplementation()).collect(Collectors.toList());
        problem.setValueList(IntStream.range(0, 3).boxed().collect(Collectors.toList()));
        problem.setEntityList(entityList);
        TestdataInterfaceEntitySolution solution = (TestdataInterfaceEntitySolution)this.solverFactory.buildSolver().solve((Object)problem);
        Assertions.assertNotNull((Object)solution);
        Assertions.assertEquals((int)entityList.size(), (int)solution.getEntityList().size());
        for (int i2 = 0; i2 < entityList.size(); ++i2) {
            Assertions.assertNotSame((Object)entityList.get(i2), (Object)solution.getEntityList().get(i2));
        }
    }
}

