/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorFactory;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import org.optaplanner.quarkus.gizmo.OptaPlannerGizmoInitializer;

public class GizmoMemberAccessorEntityEnhancer {
    private static Set<FieldInfo> visitedFields = new HashSet<FieldInfo>();
    private static Set<MethodInfo> visitedMethods = new HashSet<MethodInfo>();

    public static void addVirtualFieldGetter(ClassInfo classInfo, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!visitedFields.contains(fieldInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (className, classVisitor) -> new OptaPlannerFieldEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, fieldInfo)));
            visitedFields.add(fieldInfo);
        }
    }

    public static Optional<MethodDescriptor> addVirtualMethodGetter(ClassInfo classInfo, MethodInfo methodInfo, String name, Optional<MethodDescriptor> setterDescriptor, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!visitedMethods.contains(methodInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (className, classVisitor) -> new OptaPlannerMethodEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, methodInfo, name, setterDescriptor)));
            visitedMethods.add(methodInfo);
        }
        return setterDescriptor.map(md -> MethodDescriptor.ofMethod((String)classInfo.name().toString(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(name), (String)md.getReturnType(), (String[])md.getParameterTypes()));
    }

    public static String getVirtualGetterName(String name) {
        return "$get$optaplanner$__" + name;
    }

    public static String getVirtualSetterName(String name) {
        return "$set$optaplanner$__" + name;
    }

    public static String generateFieldAccessor(AnnotationInstance annotationInstance, IndexView indexView, ClassOutput classOutput, ClassInfo classInfo, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException {
        String generatedClassName = classInfo.name().prefix().toString() + ".$optaplanner$__" + classInfo.name().withoutPackagePrefix() + "$__" + fieldInfo.name();
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{MemberAccessor.class}).classOutput(classOutput).build();){
            GizmoMemberDescriptor member;
            Class<?> declaringClass = Class.forName(fieldInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
            FieldDescriptor memberDescriptor = FieldDescriptor.of((FieldInfo)fieldInfo);
            String name = fieldInfo.name();
            if (Modifier.isPublic(fieldInfo.flags())) {
                member = new GizmoMemberDescriptor(name, (Object)memberDescriptor, (Object)memberDescriptor, declaringClass);
            } else {
                GizmoMemberAccessorEntityEnhancer.addVirtualFieldGetter(classInfo, fieldInfo, transformers);
                String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(fieldInfo.name());
                MethodDescriptor getterDescriptor = MethodDescriptor.ofMethod((String)fieldInfo.declaringClass().name().toString(), (String)methodName, (String)fieldInfo.type().name().toString(), (String[])new String[0]);
                MethodDescriptor setterDescriptor = MethodDescriptor.ofMethod((String)fieldInfo.declaringClass().name().toString(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(fieldInfo.name()), (String)"void", (String[])new String[]{fieldInfo.type().name().toString()});
                member = new GizmoMemberDescriptor(name, (Object)getterDescriptor, (Object)memberDescriptor, declaringClass, setterDescriptor);
            }
            GizmoMemberAccessorImplementor.defineAccessorFor((ClassCreator)classCreator, (GizmoMemberDescriptor)member, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        }
        return generatedClassName;
    }

    private static String getMemberName(MethodInfo methodInfo) {
        if (methodInfo.name().startsWith("get")) {
            return methodInfo.name().substring(3, 4).toLowerCase(Locale.ROOT) + methodInfo.name().substring(4);
        }
        if (methodInfo.name().startsWith("is")) {
            return methodInfo.name().substring(2, 3).toLowerCase(Locale.ROOT) + methodInfo.name().substring(3);
        }
        return methodInfo.name();
    }

    private static Optional<MethodDescriptor> getSetterDescriptor(ClassInfo classInfo, MethodInfo methodInfo, String name) {
        if (methodInfo.name().startsWith("get") || methodInfo.name().startsWith("is")) {
            return Optional.ofNullable(classInfo.method("set" + name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1), new Type[]{methodInfo.returnType()})).map(MethodDescriptor::of);
        }
        return Optional.empty();
    }

    public static String generateMethodAccessor(AnnotationInstance annotationInstance, IndexView indexView, ClassOutput classOutput, ClassInfo classInfo, MethodInfo methodInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException {
        String generatedClassName = classInfo.name().prefix().toString() + ".$optaplanner$__" + classInfo.name().withoutPackagePrefix() + "$__" + methodInfo.name();
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{MemberAccessor.class}).classOutput(classOutput).build();){
            GizmoMemberDescriptor member;
            String name = GizmoMemberAccessorEntityEnhancer.getMemberName(methodInfo);
            Optional<MethodDescriptor> setterDescriptor = GizmoMemberAccessorEntityEnhancer.getSetterDescriptor(classInfo, methodInfo, name);
            Class<?> declaringClass = Class.forName(methodInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
            MethodDescriptor memberDescriptor = MethodDescriptor.of((MethodInfo)methodInfo);
            if (Modifier.isPublic(methodInfo.flags())) {
                member = new GizmoMemberDescriptor(name, (Object)memberDescriptor, (Object)memberDescriptor, declaringClass, (MethodDescriptor)setterDescriptor.orElse(null));
            } else {
                setterDescriptor = GizmoMemberAccessorEntityEnhancer.addVirtualMethodGetter(classInfo, methodInfo, name, setterDescriptor, transformers);
                String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(name);
                MethodDescriptor newMethodDescriptor = MethodDescriptor.ofMethod(declaringClass, (String)methodName, (Object)memberDescriptor.getReturnType(), (Object[])new Object[0]);
                member = new GizmoMemberDescriptor(name, (Object)newMethodDescriptor, (Object)memberDescriptor, declaringClass, (MethodDescriptor)setterDescriptor.orElse(null));
            }
            GizmoMemberAccessorImplementor.defineAccessorFor((ClassCreator)classCreator, (GizmoMemberDescriptor)member, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        }
        return generatedClassName;
    }

    public static String generateGizmoInitializer(ClassOutput classOutput, Set<String> generatedClassNames) {
        String generatedClassName = OptaPlannerGizmoInitializer.class.getName() + "$Implementation";
        try (ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{OptaPlannerGizmoInitializer.class}).classOutput(classOutput).build();){
            classCreator.addAnnotation(ApplicationScoped.class);
            MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.ofMethod(OptaPlannerGizmoInitializer.class, (String)"setup", Void.TYPE, (Class[])new Class[0]));
            ResultHandle memberAccessorMap = methodCreator.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            for (String generatedMemberAccessor : generatedClassNames) {
                ResultHandle generatedMemberAccessorResultHandle = methodCreator.load(generatedMemberAccessor);
                ResultHandle memberAccessorInstance = methodCreator.newInstance(MethodDescriptor.ofConstructor((String)generatedMemberAccessor, (String[])new String[0]), new ResultHandle[0]);
                methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), memberAccessorMap, new ResultHandle[]{generatedMemberAccessorResultHandle, memberAccessorInstance});
            }
            methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(GizmoMemberAccessorFactory.class, (String)"usePregeneratedMemberAccessorMap", Void.TYPE, (Class[])new Class[]{Map.class}), new ResultHandle[]{memberAccessorMap});
            methodCreator.returnValue(null);
        }
        return generatedClassName;
    }

    private static class OptaPlannerMethodEnhancingClassVisitor
    extends ClassVisitor {
        private final MethodInfo methodInfo;
        private final Class<?> clazz;
        private final String returnTypeDescriptor;
        private final Optional<MethodDescriptor> maybeSetter;
        private final String name;

        public OptaPlannerMethodEnhancingClassVisitor(ClassInfo classInfo, ClassVisitor outputClassVisitor, MethodInfo methodInfo, String name, Optional<MethodDescriptor> maybeSetter) {
            super(589824, outputClassVisitor);
            this.methodInfo = methodInfo;
            this.name = name;
            this.maybeSetter = maybeSetter;
            try {
                this.clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                this.returnTypeDescriptor = DescriptorUtils.typeToString((Type)methodInfo.returnType());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            if (this.maybeSetter.isPresent()) {
                this.addSetter(this.cv);
            }
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.returnTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(this.clazz), this.methodInfo.name(), "()" + this.returnTypeDescriptor, false);
            mv.visitInsn(org.objectweb.asm.Type.getType((String)this.returnTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }

        private void addSetter(ClassVisitor classWriter) {
            if (!this.maybeSetter.isPresent()) {
                return;
            }
            MethodDescriptor setter = this.maybeSetter.get();
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, setter.getDescriptor(), null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(this.clazz), setter.getName(), setter.getDescriptor(), false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
    }

    private static class OptaPlannerFieldEnhancingClassVisitor
    extends ClassVisitor {
        private final FieldInfo fieldInfo;
        private final Class<?> clazz;
        private final String fieldTypeDescriptor;

        public OptaPlannerFieldEnhancingClassVisitor(ClassInfo classInfo, ClassVisitor outputClassVisitor, FieldInfo fieldInfo) {
            super(589824, outputClassVisitor);
            this.fieldInfo = fieldInfo;
            try {
                this.clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                this.fieldTypeDescriptor = DescriptorUtils.typeToString((Type)fieldInfo.type());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            this.addSetter(this.cv);
        }

        private void addSetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(this.fieldInfo.name());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "(" + this.fieldTypeDescriptor + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(org.objectweb.asm.Type.getType((String)this.fieldTypeDescriptor).getOpcode(21), 1);
            mv.visitFieldInsn(181, org.objectweb.asm.Type.getInternalName(this.clazz), this.fieldInfo.name(), this.fieldTypeDescriptor);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(this.fieldInfo.name());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.fieldTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, org.objectweb.asm.Type.getInternalName(this.clazz), this.fieldInfo.name(), this.fieldTypeDescriptor);
            mv.visitInsn(org.objectweb.asm.Type.getType((String)this.fieldTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }
    }
}

