/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableReference;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.calculator.EasyScoreCalculator;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.heuristic.move.DummyMove;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveIteratorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.core.impl.heuristic.selector.move.generic.ChangeMove;
import org.optaplanner.core.impl.partitionedsearch.partitioner.SolutionPartitioner;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;
import org.optaplanner.core.impl.testdata.domain.TestdataValue;
import org.optaplanner.core.impl.testdata.domain.extended.TestdataAnnotatedExtendedEntity;
import org.optaplanner.quarkus.gizmo.OptaPlannerGizmoBeanFactory;
import org.optaplanner.quarkus.testdata.gizmo.DummyVariableListener;

class OptaPlannerProcessorGeneratedGizmoSupplierTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.test.flat-class-path", "true").setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource("org/optaplanner/quarkus/gizmoSupplierTestSolverConfig.xml", "solverConfig.xml")).addClasses(new Class[]{TestdataSolution.class, TestdataEntity.class, TestdataAnnotatedExtendedEntity.class, DummyInterfaceEntity.class, DummyAbstractEntity.class, DummyVariableListener.class, DummyChangeMoveFilter.class, DummyConstraintProvider.class, DummyEasyScoreCalculator.class, DummyEntityFilter.class, DummyIncrementalScoreCalculator.class, DummyMoveIteratorFactory.class, DummyMoveListFactory.class, DummySolutionPartitioner.class, DummyValueFilter.class}));
    @Inject
    OptaPlannerGizmoBeanFactory gizmoBeanFactory;

    OptaPlannerProcessorGeneratedGizmoSupplierTest() {
    }

    private void assertFactoryContains(Class<?> clazz) {
        Assertions.assertThat((Object)this.gizmoBeanFactory.newInstance(clazz)).isNotNull();
    }

    private void assertFactoryNotContains(Class<?> clazz) {
        Assertions.assertThat((Object)this.gizmoBeanFactory.newInstance(clazz)).isNull();
    }

    @Test
    void gizmoFactoryContainClassesReferencedInSolverConfig() {
        this.assertFactoryContains(DummyChangeMoveFilter.class);
        this.assertFactoryContains(DummyConstraintProvider.class);
        this.assertFactoryContains(DummyEasyScoreCalculator.class);
        this.assertFactoryContains(DummyEntityFilter.class);
        this.assertFactoryContains(DummyIncrementalScoreCalculator.class);
        this.assertFactoryContains(DummyMoveIteratorFactory.class);
        this.assertFactoryContains(DummyMoveListFactory.class);
        this.assertFactoryContains(DummySolutionPartitioner.class);
        this.assertFactoryContains(DummyValueFilter.class);
        this.assertFactoryContains(DummyVariableListener.class);
        this.assertFactoryNotContains(DummyInterfaceEntity.class);
        this.assertFactoryNotContains(DummyAbstractEntity.class);
    }

    public static class DummyMoveListFactory
    implements MoveListFactory<TestdataSolution> {
        public List<? extends Move<TestdataSolution>> createMoveList(TestdataSolution testdataSolution) {
            return null;
        }
    }

    public static class DummyMoveIteratorFactory
    implements MoveIteratorFactory<TestdataSolution, DummyMove> {
        public long getSize(ScoreDirector<TestdataSolution> scoreDirector) {
            return 0L;
        }

        public Iterator<DummyMove> createOriginalMoveIterator(ScoreDirector<TestdataSolution> scoreDirector) {
            return null;
        }

        public Iterator<DummyMove> createRandomMoveIterator(ScoreDirector<TestdataSolution> scoreDirector, Random workingRandom) {
            return null;
        }
    }

    public static class DummyChangeMoveFilter
    implements SelectionFilter<TestdataSolution, ChangeMove<TestdataSolution>> {
        public boolean accept(ScoreDirector<TestdataSolution> scoreDirector, ChangeMove<TestdataSolution> selection) {
            return false;
        }
    }

    public static class DummyEntityFilter
    implements SelectionFilter<TestdataSolution, TestdataEntity> {
        public boolean accept(ScoreDirector<TestdataSolution> scoreDirector, TestdataEntity selection) {
            return false;
        }
    }

    public static class DummyValueFilter
    implements SelectionFilter<TestdataSolution, TestdataValue> {
        public boolean accept(ScoreDirector<TestdataSolution> scoreDirector, TestdataValue selection) {
            return false;
        }
    }

    public static class DummyConstraintProvider
    implements ConstraintProvider {
        public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
            return new Constraint[0];
        }
    }

    public static class DummyIncrementalScoreCalculator
    implements IncrementalScoreCalculator<TestdataSolution, SimpleScore> {
        public void resetWorkingSolution(TestdataSolution workingSolution) {
        }

        public void beforeEntityAdded(Object entity) {
        }

        public void afterEntityAdded(Object entity) {
        }

        public void beforeVariableChanged(Object entity, String variableName) {
        }

        public void afterVariableChanged(Object entity, String variableName) {
        }

        public void beforeEntityRemoved(Object entity) {
        }

        public void afterEntityRemoved(Object entity) {
        }

        public SimpleScore calculateScore() {
            return null;
        }
    }

    public static class DummyEasyScoreCalculator
    implements EasyScoreCalculator<TestdataSolution, SimpleScore> {
        public SimpleScore calculateScore(TestdataSolution testdataSolution) {
            return null;
        }
    }

    public static class DummySolutionPartitioner
    implements SolutionPartitioner<TestdataSolution> {
        public List<TestdataSolution> splitWorkingSolution(ScoreDirector<TestdataSolution> scoreDirector, Integer runnablePartThreadLimit) {
            return null;
        }
    }

    @PlanningEntity
    public static abstract class DummyAbstractEntity {
        @CustomShadowVariable(sources={@PlanningVariableReference(entityClass=TestdataEntity.class, variableName="value")}, variableListenerClass=DummyVariableListener.class)
        abstract Integer getLength();
    }

    @PlanningEntity
    public static interface DummyInterfaceEntity {
        @CustomShadowVariable(sources={@PlanningVariableReference(entityClass=TestdataEntity.class, variableName="value")}, variableListenerClass=DummyVariableListener.class)
        public Integer getLength();
    }
}

