/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberAccessorImplementor;
import org.optaplanner.core.impl.domain.common.accessor.gizmo.GizmoMemberDescriptor;
import org.optaplanner.quarkus.gizmo.annotations.QuarkusRecordableAnnotatedElement;
import org.optaplanner.quarkus.gizmo.types.QuarkusRecordableTypes;

public class GizmoMemberAccessorEntityEnhancer {
    private static Set<FieldInfo> visitedFields = new HashSet<FieldInfo>();
    private static Set<MethodInfo> visitedMethods = new HashSet<MethodInfo>();

    public static void addVirtualFieldGetter(ClassInfo classInfo, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!visitedFields.contains(fieldInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (className, classVisitor) -> new OptaPlannerFieldEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, fieldInfo)));
            visitedFields.add(fieldInfo);
        }
    }

    public static Optional<MethodDescriptor> addVirtualMethodGetter(ClassInfo classInfo, MethodInfo methodInfo, String name, Optional<MethodDescriptor> setterDescriptor, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        if (!visitedMethods.contains(methodInfo)) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (className, classVisitor) -> new OptaPlannerMethodEnhancingClassVisitor(classInfo, (ClassVisitor)classVisitor, methodInfo, name, setterDescriptor)));
            visitedMethods.add(methodInfo);
        }
        return setterDescriptor.map(md -> MethodDescriptor.ofMethod((String)classInfo.name().toString(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(name), (String)md.getReturnType(), (String[])md.getParameterTypes()));
    }

    public static String getVirtualGetterName(String name) {
        return "$get$optaplanner$__" + name;
    }

    public static String getVirtualSetterName(String name) {
        return "$set$optaplanner$__" + name;
    }

    public static String generateFieldAccessor(AnnotationInstance annotationInstance, IndexView indexView, ClassOutput classOutput, ClassInfo classInfo, FieldInfo fieldInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException {
        GizmoMemberDescriptor member;
        String generatedClassName = classInfo.name().prefix().toString() + ".$optaplanner$__" + classInfo.name().withoutPackagePrefix() + "$__" + fieldInfo.name();
        ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{MemberAccessor.class}).classOutput(classOutput).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        classCreator.addAnnotation(Named.class).addValue("value", (Object)generatedClassName);
        Class<?> declaringClass = Class.forName(fieldInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        FieldDescriptor memberDescriptor = FieldDescriptor.of((FieldInfo)fieldInfo);
        String name = fieldInfo.name();
        QuarkusRecordableAnnotatedElement annotatedElement = new QuarkusRecordableAnnotatedElement(fieldInfo, indexView);
        Type type = QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)fieldInfo.type(), (IndexView)indexView);
        if (Modifier.isPublic(fieldInfo.flags())) {
            member = new GizmoMemberDescriptor(name, (Object)memberDescriptor, declaringClass, (AnnotatedElement)annotatedElement, type);
        } else {
            GizmoMemberAccessorEntityEnhancer.addVirtualFieldGetter(classInfo, fieldInfo, transformers);
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(fieldInfo.name());
            MethodDescriptor getterDescriptor = MethodDescriptor.ofMethod((String)fieldInfo.declaringClass().name().toString(), (String)methodName, (String)fieldInfo.type().name().toString(), (String[])new String[0]);
            MethodDescriptor setterDescriptor = MethodDescriptor.ofMethod((String)fieldInfo.declaringClass().name().toString(), (String)GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(fieldInfo.name()), (String)"void", (String[])new String[]{fieldInfo.type().name().toString()});
            member = new GizmoMemberDescriptor(name, (Object)getterDescriptor, declaringClass, (AnnotatedElement)annotatedElement, type, setterDescriptor);
        }
        GizmoMemberAccessorImplementor.defineAccessorFor((ClassCreator)classCreator, (GizmoMemberDescriptor)member, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        classCreator.close();
        return generatedClassName;
    }

    private static String getMemberName(MethodInfo methodInfo) {
        if (methodInfo.name().startsWith("get")) {
            return methodInfo.name().substring(3, 4).toLowerCase(Locale.ROOT) + methodInfo.name().substring(4);
        }
        if (methodInfo.name().startsWith("is")) {
            return methodInfo.name().substring(2, 3).toLowerCase(Locale.ROOT) + methodInfo.name().substring(3);
        }
        return methodInfo.name();
    }

    private static Optional<MethodDescriptor> getSetterDescriptor(ClassInfo classInfo, MethodInfo methodInfo, String name) {
        if (methodInfo.name().startsWith("get") || methodInfo.name().startsWith("is")) {
            return Optional.ofNullable(classInfo.method("set" + name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1), new org.jboss.jandex.Type[]{methodInfo.returnType()})).map(MethodDescriptor::of);
        }
        return Optional.empty();
    }

    public static String generateMethodAccessor(AnnotationInstance annotationInstance, IndexView indexView, ClassOutput classOutput, ClassInfo classInfo, MethodInfo methodInfo, BuildProducer<BytecodeTransformerBuildItem> transformers) throws ClassNotFoundException {
        GizmoMemberDescriptor member;
        String generatedClassName = classInfo.name().prefix().toString() + ".$optaplanner$__" + classInfo.name().withoutPackagePrefix() + "$__" + methodInfo.name();
        ClassCreator classCreator = ClassCreator.builder().className(generatedClassName).interfaces(new Class[]{MemberAccessor.class}).classOutput(classOutput).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        classCreator.addAnnotation(Named.class).addValue("value", (Object)generatedClassName);
        String name = GizmoMemberAccessorEntityEnhancer.getMemberName(methodInfo);
        Optional<MethodDescriptor> setterDescriptor = GizmoMemberAccessorEntityEnhancer.getSetterDescriptor(classInfo, methodInfo, name);
        Class<?> declaringClass = Class.forName(methodInfo.declaringClass().name().toString(), false, Thread.currentThread().getContextClassLoader());
        MethodDescriptor memberDescriptor = MethodDescriptor.of((MethodInfo)methodInfo);
        QuarkusRecordableAnnotatedElement annotatedElement = new QuarkusRecordableAnnotatedElement(methodInfo, indexView);
        Type type = QuarkusRecordableTypes.getQuarkusRecorderFriendlyType((org.jboss.jandex.Type)methodInfo.returnType(), (IndexView)indexView);
        if (Modifier.isPublic(methodInfo.flags())) {
            member = new GizmoMemberDescriptor(name, (Object)memberDescriptor, declaringClass, (AnnotatedElement)annotatedElement, type, (MethodDescriptor)setterDescriptor.orElse(null));
        } else {
            setterDescriptor = GizmoMemberAccessorEntityEnhancer.addVirtualMethodGetter(classInfo, methodInfo, name, setterDescriptor, transformers);
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(name);
            MethodDescriptor newMethodDescriptor = MethodDescriptor.ofMethod(declaringClass, (String)methodName, (Object)GizmoMemberAccessorEntityEnhancer.getTypeDescriptor(type), (Object[])new Object[0]);
            member = new GizmoMemberDescriptor(name, (Object)newMethodDescriptor, declaringClass, (AnnotatedElement)annotatedElement, type, (MethodDescriptor)setterDescriptor.orElse(null));
        }
        GizmoMemberAccessorImplementor.defineAccessorFor((ClassCreator)classCreator, (GizmoMemberDescriptor)member, Class.forName(annotationInstance.name().toString(), false, Thread.currentThread().getContextClassLoader()));
        classCreator.close();
        return generatedClassName;
    }

    private static String getTypeDescriptor(Type type) throws ClassNotFoundException {
        boolean isGeneric;
        String typeName = type.getTypeName();
        int genericStart = typeName.indexOf(60);
        boolean bl = isGeneric = genericStart != -1;
        if (isGeneric) {
            int genericEnd = typeName.lastIndexOf(62);
            return org.objectweb.asm.Type.getDescriptor(Class.forName(typeName.substring(0, genericStart) + typeName.substring(genericEnd + 1)));
        }
        return org.objectweb.asm.Type.getDescriptor(Class.forName(typeName));
    }

    private static class OptaPlannerMethodEnhancingClassVisitor
    extends ClassVisitor {
        private final MethodInfo methodInfo;
        private final Class<?> clazz;
        private final String returnTypeDescriptor;
        private final Optional<MethodDescriptor> maybeSetter;
        private final String name;

        public OptaPlannerMethodEnhancingClassVisitor(ClassInfo classInfo, ClassVisitor outputClassVisitor, MethodInfo methodInfo, String name, Optional<MethodDescriptor> maybeSetter) {
            super(589824, outputClassVisitor);
            this.methodInfo = methodInfo;
            this.name = name;
            this.maybeSetter = maybeSetter;
            try {
                this.clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                this.returnTypeDescriptor = DescriptorUtils.typeToString((org.jboss.jandex.Type)methodInfo.returnType());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            if (this.maybeSetter.isPresent()) {
                this.addSetter(this.cv);
            }
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.returnTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(this.clazz), this.methodInfo.name(), "()" + this.returnTypeDescriptor, false);
            mv.visitInsn(org.objectweb.asm.Type.getType((String)this.returnTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }

        private void addSetter(ClassVisitor classWriter) {
            if (!this.maybeSetter.isPresent()) {
                return;
            }
            MethodDescriptor setter = this.maybeSetter.get();
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(this.name);
            MethodVisitor mv = classWriter.visitMethod(1, methodName, setter.getDescriptor(), null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName(this.clazz), setter.getName(), setter.getDescriptor(), false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
    }

    private static class OptaPlannerFieldEnhancingClassVisitor
    extends ClassVisitor {
        private final FieldInfo fieldInfo;
        private final Class<?> clazz;
        private final String fieldTypeDescriptor;

        public OptaPlannerFieldEnhancingClassVisitor(ClassInfo classInfo, ClassVisitor outputClassVisitor, FieldInfo fieldInfo) {
            super(589824, outputClassVisitor);
            this.fieldInfo = fieldInfo;
            try {
                this.clazz = Class.forName(classInfo.name().toString(), false, Thread.currentThread().getContextClassLoader());
                this.fieldTypeDescriptor = DescriptorUtils.typeToString((org.jboss.jandex.Type)fieldInfo.type());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public void visitEnd() {
            super.visitEnd();
            this.addGetter(this.cv);
            this.addSetter(this.cv);
        }

        private void addSetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualSetterName(this.fieldInfo.name());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "(" + this.fieldTypeDescriptor + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(org.objectweb.asm.Type.getType((String)this.fieldTypeDescriptor).getOpcode(21), 1);
            mv.visitFieldInsn(181, org.objectweb.asm.Type.getInternalName(this.clazz), this.fieldInfo.name(), this.fieldTypeDescriptor);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }

        private void addGetter(ClassVisitor classWriter) {
            String methodName = GizmoMemberAccessorEntityEnhancer.getVirtualGetterName(this.fieldInfo.name());
            MethodVisitor mv = classWriter.visitMethod(1, methodName, "()" + this.fieldTypeDescriptor, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, org.objectweb.asm.Type.getInternalName(this.clazz), this.fieldInfo.name(), this.fieldTypeDescriptor);
            mv.visitInsn(org.objectweb.asm.Type.getType((String)this.fieldTypeDescriptor).getOpcode(172));
            mv.visitMaxs(0, 0);
        }
    }
}

