/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.util.Collections;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.domain.common.DomainAccessType;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.quarkus.testdata.normal.constraints.TestdataQuarkusConstraintProvider;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusEntity;
import org.optaplanner.quarkus.testdata.normal.domain.TestdataQuarkusSolution;

class OptaPlannerProcessorXMLDefaultTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().setArchiveProducer(() -> (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataQuarkusEntity.class, TestdataQuarkusSolution.class, TestdataQuarkusConstraintProvider.class})).addAsResource("solverConfig.xml"));
    @Inject
    SolverConfig solverConfig;
    @Inject
    SolverFactory<TestdataQuarkusSolution> solverFactory;

    OptaPlannerProcessorXMLDefaultTest() {
    }

    @Test
    void solverConfigXml_default() {
        Assertions.assertNotNull((Object)this.solverConfig);
        Assertions.assertEquals(TestdataQuarkusSolution.class, (Object)this.solverConfig.getSolutionClass());
        Assertions.assertEquals((Object)DomainAccessType.GIZMO, (Object)this.solverConfig.getDomainAccessType());
        Assertions.assertEquals(Collections.singletonList(TestdataQuarkusEntity.class), (Object)this.solverConfig.getEntityClassList());
        Assertions.assertEquals(TestdataQuarkusConstraintProvider.class, (Object)this.solverConfig.getScoreDirectorFactoryConfig().getConstraintProviderClass());
        Assertions.assertEquals((long)2L, (long)this.solverConfig.getTerminationConfig().getSecondsSpentLimit());
        Assertions.assertNotNull(this.solverFactory);
        Assertions.assertNotNull((Object)this.solverFactory.buildSolver());
    }
}

