/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus;

import io.quarkus.test.QuarkusUnitTest;
import java.time.Duration;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.quarkus.constraints.TestdataPlanningConstraintProvider;
import org.optaplanner.quarkus.domain.TestdataPlanningEntity;
import org.optaplanner.quarkus.domain.TestdataPlanningSolution;

public class OptaPlannerProcessorSolverPropertiesTest {
    @RegisterExtension
    static final QuarkusUnitTest config = new QuarkusUnitTest().overrideConfigKey("quarkus.optaplanner.solver.environment-mode", "FULL_ASSERT").overrideConfigKey("quarkus.optaplanner.solver.move-thread-count", "2").overrideConfigKey("quarkus.optaplanner.solver.termination.spent-limit", "4h").overrideConfigKey("quarkus.optaplanner.solver.termination.unimproved-spent-limit", "5h").overrideConfigKey("quarkus.optaplanner.solver.termination.best-score-limit", "0").setArchiveProducer(() -> (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{TestdataPlanningEntity.class, TestdataPlanningSolution.class, TestdataPlanningConstraintProvider.class}));
    @Inject
    SolverConfig solverConfig;
    @Inject
    SolverFactory<TestdataPlanningSolution> solverFactory;

    @Test
    public void solverProperties() {
        Assertions.assertEquals((Object)EnvironmentMode.FULL_ASSERT, (Object)this.solverConfig.getEnvironmentMode());
        Assertions.assertEquals((Object)"2", (Object)this.solverConfig.getMoveThreadCount());
        Assertions.assertNotNull(this.solverFactory);
    }

    @Test
    public void terminationProperties() {
        Assertions.assertEquals((Object)Duration.ofHours(4L), (Object)this.solverConfig.getTerminationConfig().getSpentLimit());
        Assertions.assertEquals((Object)Duration.ofHours(5L), (Object)this.solverConfig.getTerminationConfig().getUnimprovedSpentLimit());
        Assertions.assertEquals((Object)SimpleScore.of((int)0).toString(), (Object)this.solverConfig.getTerminationConfig().getBestScoreLimit());
    }
}

