/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.quarkus.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.drools.core.base.ClassFieldAccessorFactory;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.SolverManagerConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;
import org.optaplanner.core.impl.score.director.easy.EasyScoreCalculator;
import org.optaplanner.core.impl.score.director.incremental.IncrementalScoreCalculator;
import org.optaplanner.quarkus.OptaPlannerBeanProvider;
import org.optaplanner.quarkus.OptaPlannerRecorder;
import org.optaplanner.quarkus.deployment.DotNames;
import org.optaplanner.quarkus.deployment.OptaPlannerBuildTimeConfig;

class OptaPlannerProcessor {
    OptaPlannerBuildTimeConfig optaPlannerBuildTimeConfig;

    OptaPlannerProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("optaplanner");
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchSolverConfigXml() {
        String solverConfigXML = this.optaPlannerBuildTimeConfig.solverConfigXml.isPresent() ? this.optaPlannerBuildTimeConfig.solverConfigXml.get() : "solverConfig.xml";
        return new HotDeploymentWatchedFileBuildItem(solverConfigXML);
    }

    @BuildStep
    HotDeploymentWatchedFileBuildItem watchScoreDrl() {
        return new HotDeploymentWatchedFileBuildItem("constraints.drl");
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{OptaPlannerBeanProvider.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordSolverFactory(OptaPlannerRecorder recorder, RecorderContext recorderContext, CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        SolverConfig solverConfig;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.optaPlannerBuildTimeConfig.solverConfigXml.isPresent()) {
            String solverConfigXML = this.optaPlannerBuildTimeConfig.solverConfigXml.get();
            if (classLoader.getResource(solverConfigXML) == null) {
                throw new ConfigurationException("Invalid quarkus.optaplanner.solverConfigXML property (" + solverConfigXML + "): that classpath resource does not exist.");
            }
            solverConfig = SolverConfig.createFromXmlResource((String)solverConfigXML, (ClassLoader)classLoader);
        } else {
            solverConfig = classLoader.getResource("solverConfig.xml") != null ? SolverConfig.createFromXmlResource((String)"solverConfig.xml", (ClassLoader)classLoader) : new SolverConfig(classLoader);
        }
        solverConfig.setClassLoader(null);
        IndexView indexView = combinedIndex.getIndex();
        this.applySolverProperties(recorderContext, indexView, solverConfig);
        if (solverConfig.getSolutionClass() != null) {
            Type jandexType = Type.create((DotName)DotName.createSimple((String)solverConfig.getSolutionClass().getName()), (Type.Kind)Type.Kind.CLASS);
            reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem(jandexType));
        }
        ArrayList<Class> reflectiveClassList = new ArrayList<Class>(5);
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
        if (scoreDirectorFactoryConfig != null) {
            if (scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() != null) {
                reflectiveClassList.add(scoreDirectorFactoryConfig.getEasyScoreCalculatorClass());
            }
            if (scoreDirectorFactoryConfig.getConstraintProviderClass() != null) {
                reflectiveClassList.add(scoreDirectorFactoryConfig.getConstraintProviderClass());
            }
            if (scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() != null) {
                reflectiveClassList.add(scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass());
            }
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, (String[])reflectiveClassList.stream().map(Class::getName).toArray(String[]::new)));
        SolverManagerConfig solverManagerConfig = new SolverManagerConfig();
        this.optaPlannerBuildTimeConfig.solverManager.parallelSolverCount.ifPresent(arg_0 -> ((SolverManagerConfig)solverManagerConfig).setParallelSolverCount(arg_0));
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverConfigSupplier(solverConfig)).done());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SolverManagerConfig.class).scope(Singleton.class)).defaultBean()).supplier(recorder.solverManagerConfig(solverManagerConfig)).done());
    }

    private void applySolverProperties(RecorderContext recorderContext, IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getScanAnnotatedClassesConfig() != null) {
            throw new IllegalArgumentException("Do not use scanAnnotatedClasses with the Quarkus extension, because the Quarkus extension scans too.\nMaybe delete the scanAnnotatedClasses element in the solver config.");
        }
        if (solverConfig.getSolutionClass() == null) {
            solverConfig.setSolutionClass(this.findSolutionClass(recorderContext, indexView));
        }
        if (solverConfig.getEntityClassList() == null) {
            solverConfig.setEntityClassList(this.findEntityClassList(recorderContext, indexView));
        }
        this.applyScoreDirectorFactoryProperties(indexView, solverConfig);
        this.optaPlannerBuildTimeConfig.solver.environmentMode.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setEnvironmentMode(arg_0));
        this.optaPlannerBuildTimeConfig.solver.moveThreadCount.ifPresent(arg_0 -> ((SolverConfig)solverConfig).setMoveThreadCount(arg_0));
        this.applyTerminationProperties(solverConfig);
    }

    private Class<?> findSolutionClass(RecorderContext recorderContext, IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_SOLUTION);
        if (annotationInstances.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningSolution.class.getSimpleName() + " annotation.");
        }
        AnnotationTarget solutionTarget = ((AnnotationInstance)annotationInstances.iterator().next()).target();
        if (solutionTarget.kind() != AnnotationTarget.Kind.CLASS) {
            throw new IllegalStateException("A target (" + solutionTarget + ") with a @" + PlanningSolution.class.getSimpleName() + " must be a class.");
        }
        return recorderContext.classProxy(solutionTarget.asClass().name().toString());
    }

    private List<Class<?>> findEntityClassList(RecorderContext recorderContext, IndexView indexView) {
        Collection annotationInstances = indexView.getAnnotations(DotNames.PLANNING_ENTITY);
        if (annotationInstances.isEmpty()) {
            throw new IllegalStateException("No classes (" + this.convertAnnotationInstancesToString(annotationInstances) + ") found with a @" + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        List targetList = annotationInstances.stream().map(AnnotationInstance::target).collect(Collectors.toList());
        if (targetList.stream().anyMatch(target -> target.kind() != AnnotationTarget.Kind.CLASS)) {
            throw new IllegalStateException("All targets (" + targetList + ") with a @" + PlanningEntity.class.getSimpleName() + " must be a class.");
        }
        return targetList.stream().map(target -> recorderContext.classProxy(target.asClass().name().toString())).collect(Collectors.toList());
    }

    private void applyScoreDirectorFactoryProperties(IndexView indexView, SolverConfig solverConfig) {
        if (solverConfig.getScoreDirectorFactoryConfig() == null) {
            ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            scoreDirectorFactoryConfig.setEasyScoreCalculatorClass(this.findImplementingClass(EasyScoreCalculator.class, indexView));
            scoreDirectorFactoryConfig.setConstraintProviderClass(this.findImplementingClass(ConstraintProvider.class, indexView));
            scoreDirectorFactoryConfig.setIncrementalScoreCalculatorClass(this.findImplementingClass(IncrementalScoreCalculator.class, indexView));
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader.getResource("constraints.drl") != null) {
                scoreDirectorFactoryConfig.setScoreDrlList(Collections.singletonList("constraints.drl"));
            }
            if (scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getConstraintProviderClass() == null && scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() == null && scoreDirectorFactoryConfig.getScoreDrlList() == null) {
                throw new IllegalStateException("No classes found that implement " + EasyScoreCalculator.class.getSimpleName() + ", " + ConstraintProvider.class.getSimpleName() + " or " + IncrementalScoreCalculator.class.getSimpleName() + ", nor a " + "constraints.drl" + " resource.");
            }
            solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        }
    }

    private <T> Class<? extends T> findImplementingClass(Class<T> targetClass, IndexView indexView) {
        Collection classInfos = indexView.getAllKnownImplementors(DotName.createSimple((String)targetClass.getName()));
        if (classInfos.size() > 1) {
            throw new IllegalStateException("Multiple classes (" + this.convertClassInfosToString(classInfos) + ") found that implement the interface " + targetClass.getSimpleName() + ".");
        }
        if (classInfos.isEmpty()) {
            return null;
        }
        String className = ((ClassInfo)classInfos.iterator().next()).name().toString();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + className + ") cannot be created during deployment.", e);
        }
    }

    private void applyTerminationProperties(SolverConfig solverConfig) {
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        if (terminationConfig == null) {
            terminationConfig = new TerminationConfig();
            solverConfig.setTerminationConfig(terminationConfig);
        }
        this.optaPlannerBuildTimeConfig.solver.termination.spentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
        this.optaPlannerBuildTimeConfig.solver.termination.unimprovedSpentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
        this.optaPlannerBuildTimeConfig.solver.termination.bestScoreLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
    }

    private String convertAnnotationInstancesToString(Collection<AnnotationInstance> annotationInstances) {
        return "[" + annotationInstances.stream().map(instance -> instance.target().toString()).collect(Collectors.joining(", ")) + "]";
    }

    private String convertClassInfosToString(Collection<ClassInfo> classInfos) {
        return "[" + classInfos.stream().map(instance -> instance.name().toString()).collect(Collectors.joining(", ")) + "]";
    }

    @BuildStep
    public RuntimeInitializedClassBuildItem nativeImageDroolsTricks() {
        return new RuntimeInitializedClassBuildItem(ClassFieldAccessorFactory.class.getName());
    }
}

