/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.persistence.xstream.api.score;

import com.thoughtworks.xstream.XStream;
import java.io.Serializable;
import org.junit.Assert;
import org.optaplanner.core.api.score.Score;

public abstract class AbstractScoreXStreamConverterTest {
    protected <S extends Score, W extends TestScoreWrapper<S>> void assertSerializeAndDeserialize(S expectedScore, W input) {
        XStream xStream = new XStream();
        xStream.setMode(1002);
        xStream.processAnnotations(input.getClass());
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByRegExp(new String[]{"org\\.optaplanner\\.\\w+\\.config\\..*", "org\\.optaplanner\\.persistence\\.xstream\\..*\\$Test\\w+ScoreWrapper"});
        String xmlString = xStream.toXML(input);
        TestScoreWrapper output = (TestScoreWrapper)xStream.fromXML(xmlString);
        Assert.assertEquals(expectedScore, output.getScore());
        String regex = expectedScore != null ? "<([\\w\\-\\.]+)( id=\"\\d+\")?>\\s*<score( id=\"\\d+\")?>" + expectedScore.toString().replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]") + "</score>\\s*</\\1>" : "<([\\w\\-\\.]+)( id=\"\\d+\")?/>";
        if (!xmlString.matches(regex)) {
            Assert.fail((String)("Regular expression match failed.\nExpected regular expression: " + regex + "\nActual string: " + xmlString));
        }
    }

    public static abstract class TestScoreWrapper<S extends Score>
    implements Serializable {
        public abstract S getScore();
    }
}

