/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.optaplanner.examples.common.app.LoggingTest;
import org.optaplanner.examples.common.business.ProblemFileComparator;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;

@RunWith(value=Parameterized.class)
public abstract class SolutionImporterTest
extends LoggingTest {
    protected AbstractSolutionImporter solutionImporter;
    protected File importFile;

    protected static Collection<Object[]> getInputFilesAsParameters(AbstractSolutionImporter solutionImporter) {
        ArrayList<File> fileList = new ArrayList<File>(0);
        File inputDir = solutionImporter.getInputDir();
        SolutionImporterTest.addFiles(solutionImporter, fileList, inputDir);
        Collections.sort(fileList, new ProblemFileComparator());
        ArrayList<Object[]> filesAsParameters = new ArrayList<Object[]>();
        for (File file : fileList) {
            filesAsParameters.add(new Object[]{file});
        }
        return filesAsParameters;
    }

    private static void addFiles(final AbstractSolutionImporter solutionImporter, List<File> fileList, File directory) {
        List<File> newFileList = Arrays.asList(directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return solutionImporter.acceptInputFile(file);
            }
        }));
        fileList.addAll(newFileList);
        for (File subDirectory : directory.listFiles((FileFilter)DirectoryFileFilter.INSTANCE)) {
            SolutionImporterTest.addFiles(solutionImporter, fileList, subDirectory);
        }
    }

    protected SolutionImporterTest(File importFile) {
        this.importFile = importFile;
    }

    @Before
    public void setUp() {
        this.solutionImporter = this.createSolutionImporter();
    }

    protected abstract AbstractSolutionImporter createSolutionImporter();

    @Test
    public void readSolution() {
        this.solutionImporter.readSolution(this.importFile);
    }
}

