/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.core.impl.solver.io.XStreamConfigReader;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

public class PlannerBenchmarkConfigTest {
    @Test
    public void validNameWithUnderscoreAndSpace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Valid_name with space_and_underscore");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        config.validate();
    }

    @Test
    public void validNameWithJapanese() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Valid name (\u6709\u52b9\u540d in Japanese)");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        config.validate();
    }

    @Test
    public void invalidNameWithSlash() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("slash/name");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void invalidNameWithSuffixWhitespace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName("Suffixed with space ");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void invalidNameWithPrefixWhitespace() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setName(" prefixed with space");
        config.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void noSolverConfigs() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setSolverBenchmarkConfigList(null);
        config.setSolverBenchmarkBluePrintConfigList(null);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).validate());
    }

    @Test
    public void nonUniqueSolverConfigName() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        String sbcName = "x";
        SolverBenchmarkConfig sbc1 = new SolverBenchmarkConfig();
        sbc1.setName("x");
        SolverBenchmarkConfig sbc2 = new SolverBenchmarkConfig();
        sbc2.setName("x");
        config.setSolverBenchmarkConfigList(Arrays.asList(sbc1, sbc2));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).generateSolverBenchmarkConfigNames());
    }

    @Test
    public void uniqueNamesGenerated() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        SolverBenchmarkConfig sbc1 = new SolverBenchmarkConfig();
        SolverBenchmarkConfig sbc2 = new SolverBenchmarkConfig();
        SolverBenchmarkConfig sbc3 = new SolverBenchmarkConfig();
        sbc3.setName("Config_1");
        List<SolverBenchmarkConfig> configs = Arrays.asList(sbc1, sbc2, sbc3);
        config.setSolverBenchmarkConfigList(configs);
        config.generateSolverBenchmarkConfigNames();
        Assertions.assertThat((String)sbc3.getName()).isEqualTo("Config_1");
        TreeSet<String> names = new TreeSet<String>();
        for (SolverBenchmarkConfig sc : configs) {
            names.add(sc.getName());
        }
        for (int i = 0; i < configs.size(); ++i) {
            Assertions.assertThat(names).contains((Object[])new String[]{"Config_" + i});
        }
    }

    @Test
    public void resolveParallelBenchmarkCountAutomatically() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(-1)).isEqualTo(1);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(0)).isEqualTo(1);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(1)).isEqualTo(1);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(2)).isEqualTo(1);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(3)).isEqualTo(2);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(4)).isEqualTo(2);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(5)).isEqualTo(3);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(6)).isEqualTo(4);
        Assertions.assertThat((int)config.resolveParallelBenchmarkCountAutomatically(17)).isEqualTo(9);
    }

    @Test
    public void resolveParallelBenchmarkCountFromFormula() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setParallelBenchmarkCount("availableProcessorCount+1");
        Assertions.assertThat((int)config.resolveParallelBenchmarkCount()).isEqualTo(Runtime.getRuntime().availableProcessors());
    }

    @Test
    public void parallelBenchmarkDisabledByDefault() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        Assertions.assertThat((int)config.resolveParallelBenchmarkCount()).isEqualTo(1);
    }

    @Test
    public void resolvedParallelBenchmarkCountNegative() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setParallelBenchmarkCount("-1");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> ((PlannerBenchmarkConfig)config).resolveParallelBenchmarkCount());
    }

    @Test
    public void calculateWarmUpTimeMillisSpentLimit() {
        PlannerBenchmarkConfig config = new PlannerBenchmarkConfig();
        config.setWarmUpHoursSpentLimit(Long.valueOf(1L));
        config.setWarmUpMinutesSpentLimit(Long.valueOf(2L));
        config.setWarmUpSecondsSpentLimit(Long.valueOf(5L));
        config.setWarmUpMillisecondsSpentLimit(Long.valueOf(753L));
        Assertions.assertThat((Long)config.calculateWarmUpTimeMillisSpentLimit()).isEqualTo(3725753L);
    }

    @Test
    public void xmlConfigFileRemainsSameAfterReadWrite() throws IOException {
        String benchmarkConfigResource = "org/optaplanner/benchmark/config/testdataBenchmarkConfigNoInheritence.xml";
        String originalXml = IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(benchmarkConfigResource), (Charset)StandardCharsets.UTF_8);
        PlannerBenchmarkConfig benchmarkConfig = PlannerBenchmarkConfig.createFromXmlResource((String)benchmarkConfigResource);
        Assertions.assertThat((Object)PlannerBenchmarkFactory.create((PlannerBenchmarkConfig)benchmarkConfig).buildPlannerBenchmark((Object[])new TestdataSolution[]{new TestdataSolution()})).isNotNull();
        XStream xStream = XStreamConfigReader.buildXStreamPortable((ClassLoader)this.getClass().getClassLoader(), (Class[])new Class[]{PlannerBenchmarkConfig.class});
        xStream.setMode(1001);
        String savedXml = xStream.toXML((Object)benchmarkConfig);
        Assertions.assertThat((String)savedXml.trim()).isEqualTo(originalXml.trim());
    }
}

