/*
 * Decompiled with CFR 0.152.
 */
package org.openweathermap.api.model.uvi;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.openweathermap.api.gson.SecondsDateTypeAdapter;

public class Uvi {
    public static final Type TYPE = TypeToken.get(Uvi.class).getType();
    public static final Type TYPE_LIST = TypeToken.getParameterized(List.class, (Type[])new Type[]{TYPE}).getType();
    @SerializedName(value="lon")
    private String longitude;
    @SerializedName(value="lat")
    private String latitude;
    @JsonAdapter(value=SecondsDateTypeAdapter.class)
    @SerializedName(value="date")
    private Date date;
    @SerializedName(value="date_iso")
    private String isoDate;
    @SerializedName(value="value")
    private double ultravioletIndex;

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public Date getDate() {
        return this.date;
    }

    public String getIsoDate() {
        return this.isoDate;
    }

    public double getUltravioletIndex() {
        return this.ultravioletIndex;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setIsoDate(String isoDate) {
        this.isoDate = isoDate;
    }

    public void setUltravioletIndex(double ultravioletIndex) {
        this.ultravioletIndex = ultravioletIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Uvi)) {
            return false;
        }
        Uvi other = (Uvi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$longitude = this.getLongitude();
        String other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !this$longitude.equals(other$longitude)) {
            return false;
        }
        String this$latitude = this.getLatitude();
        String other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !this$latitude.equals(other$latitude)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$isoDate = this.getIsoDate();
        String other$isoDate = other.getIsoDate();
        if (this$isoDate == null ? other$isoDate != null : !this$isoDate.equals(other$isoDate)) {
            return false;
        }
        return Double.compare(this.getUltravioletIndex(), other.getUltravioletIndex()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Uvi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : $longitude.hashCode());
        String $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : $latitude.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $isoDate = this.getIsoDate();
        result = result * 59 + ($isoDate == null ? 43 : $isoDate.hashCode());
        long $ultravioletIndex = Double.doubleToLongBits(this.getUltravioletIndex());
        result = result * 59 + (int)($ultravioletIndex >>> 32 ^ $ultravioletIndex);
        return result;
    }

    public String toString() {
        return "Uvi(longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", date=" + this.getDate() + ", isoDate=" + this.getIsoDate() + ", ultravioletIndex=" + this.getUltravioletIndex() + ")";
    }
}

