/*
 * Decompiled with CFR 0.152.
 */
package org.openweathermap.api.model.forecast.daily;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;
import org.openweathermap.api.model.AbstractWeatherResponse;
import org.openweathermap.api.model.WindDirection;
import org.openweathermap.api.model.forecast.Forecast;
import org.openweathermap.api.model.forecast.ForecastInformation;
import org.openweathermap.api.model.forecast.daily.Temperature;

public class DailyForecast
extends AbstractWeatherResponse
implements Forecast {
    public static final Type TYPE = new TypeToken<ForecastInformation<DailyForecast>>(){}.getType();
    public static final Type TYPE_LIST = TypeToken.getParameterized(List.class, (Type[])new Type[]{TYPE}).getType();
    @SerializedName(value="temp")
    private Temperature temperature;
    private double humidity;
    private double speed;
    private double clouds;
    private double rain;
    @SerializedName(value="deg")
    private WindDirection direction;

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DailyForecast)) {
            return false;
        }
        DailyForecast other = (DailyForecast)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Temperature this$temperature = this.getTemperature();
        Temperature other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        if (Double.compare(this.getHumidity(), other.getHumidity()) != 0) {
            return false;
        }
        if (Double.compare(this.getSpeed(), other.getSpeed()) != 0) {
            return false;
        }
        if (Double.compare(this.getClouds(), other.getClouds()) != 0) {
            return false;
        }
        if (Double.compare(this.getRain(), other.getRain()) != 0) {
            return false;
        }
        WindDirection this$direction = this.getDirection();
        WindDirection other$direction = other.getDirection();
        return !(this$direction == null ? other$direction != null : !((Object)this$direction).equals(other$direction));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DailyForecast;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Temperature $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        long $humidity = Double.doubleToLongBits(this.getHumidity());
        result = result * 59 + (int)($humidity >>> 32 ^ $humidity);
        long $speed = Double.doubleToLongBits(this.getSpeed());
        result = result * 59 + (int)($speed >>> 32 ^ $speed);
        long $clouds = Double.doubleToLongBits(this.getClouds());
        result = result * 59 + (int)($clouds >>> 32 ^ $clouds);
        long $rain = Double.doubleToLongBits(this.getRain());
        result = result * 59 + (int)($rain >>> 32 ^ $rain);
        WindDirection $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)$direction).hashCode());
        return result;
    }

    @Generated
    public DailyForecast() {
    }

    @Generated
    public Temperature getTemperature() {
        return this.temperature;
    }

    @Generated
    public double getHumidity() {
        return this.humidity;
    }

    @Generated
    public double getSpeed() {
        return this.speed;
    }

    @Generated
    public double getClouds() {
        return this.clouds;
    }

    @Generated
    public double getRain() {
        return this.rain;
    }

    @Generated
    public WindDirection getDirection() {
        return this.direction;
    }

    @Generated
    public void setTemperature(Temperature temperature) {
        this.temperature = temperature;
    }

    @Generated
    public void setHumidity(double humidity) {
        this.humidity = humidity;
    }

    @Generated
    public void setSpeed(double speed) {
        this.speed = speed;
    }

    @Generated
    public void setClouds(double clouds) {
        this.clouds = clouds;
    }

    @Generated
    public void setRain(double rain) {
        this.rain = rain;
    }

    @Generated
    public void setDirection(WindDirection direction) {
        this.direction = direction;
    }

    @Override
    @Generated
    public String toString() {
        return "DailyForecast(temperature=" + this.getTemperature() + ", humidity=" + this.getHumidity() + ", speed=" + this.getSpeed() + ", clouds=" + this.getClouds() + ", rain=" + this.getRain() + ", direction=" + this.getDirection() + ")";
    }
}

