/*
 * Decompiled with CFR 0.152.
 */
package org.openweathermap.api.example;

import org.openweathermap.api.UrlConnectionDataWeatherClient;
import org.openweathermap.api.model.currentweather.CurrentWeather;
import org.openweathermap.api.query.Language;
import org.openweathermap.api.query.QueryBuilderPicker;
import org.openweathermap.api.query.ResponseFormat;
import org.openweathermap.api.query.Type;
import org.openweathermap.api.query.UnitFormat;
import org.openweathermap.api.query.currentweather.ByCityNameBuilder;
import org.openweathermap.api.query.currentweather.CurrentWeatherOneLocationQuery;

public class CurrentWeatherOneLocationExample {
    private static final String API_KEY = "API_KEY_VALUE";

    public static void main(String[] args) {
        UrlConnectionDataWeatherClient client = new UrlConnectionDataWeatherClient(API_KEY);
        CurrentWeatherOneLocationQuery currentWeatherOneLocationQuery = (CurrentWeatherOneLocationQuery)((ByCityNameBuilder)((ByCityNameBuilder)((ByCityNameBuilder)QueryBuilderPicker.pick().currentWeather().oneLocation().byCityName("Kharkiv").countryCode("UA").type(Type.ACCURATE).language(Language.ENGLISH)).responseFormat(ResponseFormat.JSON)).unitFormat(UnitFormat.METRIC)).build();
        CurrentWeather currentWeather = client.getCurrentWeather(currentWeatherOneLocationQuery);
        System.out.println(CurrentWeatherOneLocationExample.prettyPrint(currentWeather));
    }

    private static String prettyPrint(CurrentWeather currentWeather) {
        return String.format("Current weather in %s(%s):\ntemperature: %.1f \u2103\nhumidity: %.1f %%\npressure: %.1f hPa\n", currentWeather.getCityName(), currentWeather.getSystemParameters().getCountry(), currentWeather.getMainParameters().getTemperature(), currentWeather.getMainParameters().getHumidity(), currentWeather.getMainParameters().getPressure());
    }
}

