/*
 * Decompiled with CFR 0.152.
 */
package org.openweathermap.api.example;

import java.util.List;
import org.openweathermap.api.UrlConnectionDataWeatherClient;
import org.openweathermap.api.common.Coordinate;
import org.openweathermap.api.model.currentweather.CurrentWeather;
import org.openweathermap.api.query.Language;
import org.openweathermap.api.query.QueryBuilderPicker;
import org.openweathermap.api.query.UnitFormat;
import org.openweathermap.api.query.currentweather.CurrentWeatherMultipleLocationsQuery;
import org.openweathermap.api.query.currentweather.InCycle;
import org.openweathermap.api.query.currentweather.InCycleBuilder;

public class CurrentWeatherMultipleLocationsExample {
    private static final String API_KEY = "API_KEY_VALUE";

    public static void main(String[] args) {
        UrlConnectionDataWeatherClient client = new UrlConnectionDataWeatherClient(API_KEY);
        InCycle inCycle = (InCycle)((InCycleBuilder)((InCycleBuilder)QueryBuilderPicker.pick().currentWeather().multipleLocations().inCycle(new Coordinate("36.230383", "49.9935"), 5).language(Language.ENGLISH)).unitFormat(UnitFormat.METRIC)).build();
        List currentWeatherList = client.getCurrentWeather((CurrentWeatherMultipleLocationsQuery)inCycle);
        for (CurrentWeather currentWeather : currentWeatherList) {
            System.out.println(CurrentWeatherMultipleLocationsExample.prettyPrint(currentWeather));
        }
    }

    private static String prettyPrint(CurrentWeather currentWeather) {
        return String.format("Current weather in %s(%s):\ntemperature: %.1f \u2103\nhumidity: %.1f %%\npressure: %.1f hPa\n", currentWeather.getCityName(), currentWeather.getSystemParameters().getCountry(), currentWeather.getMainParameters().getTemperature(), currentWeather.getMainParameters().getHumidity(), currentWeather.getMainParameters().getPressure());
    }
}

