/*
 * Decompiled with CFR 0.152.
 */
package org.openweathermap.api.example;

import org.openweathermap.api.UrlConnectionWeatherClient;
import org.openweathermap.api.model.forecast.ForecastInformation;
import org.openweathermap.api.model.forecast.hourly.HourlyForecast;
import org.openweathermap.api.query.Language;
import org.openweathermap.api.query.QueryBuilderPicker;
import org.openweathermap.api.query.UnitFormat;
import org.openweathermap.api.query.forecast.hourly.ByCityName;
import org.openweathermap.api.query.forecast.hourly.ByCityNameBuilder;
import org.openweathermap.api.query.forecast.hourly.HourlyForecastQuery;

public class HourlyForecastExample {
    private static final String API_KEY = "API_KEY_VALUE";

    public static void main(String[] args) {
        UrlConnectionWeatherClient client = new UrlConnectionWeatherClient(API_KEY);
        ByCityName byCityNameForecast = (ByCityName)((ByCityNameBuilder)((ByCityNameBuilder)((ByCityNameBuilder)QueryBuilderPicker.pick().forecast().hourly().byCityName("Kharkiv").countryCode("UA").unitFormat(UnitFormat.METRIC)).language(Language.ENGLISH)).count(5)).build();
        ForecastInformation forecastInformation = client.getForecastInformation((HourlyForecastQuery)byCityNameForecast);
        System.out.println("Forecasts for " + forecastInformation.getCity() + ":");
        for (HourlyForecast forecast : forecastInformation.getForecasts()) {
            System.out.println(HourlyForecastExample.prettyPrint(forecast));
        }
    }

    private static String prettyPrint(HourlyForecast hourlyForecast) {
        return String.format("Forecast for %s:\ntemperature: %.1f \u2103\nhumidity: %.1f %%\npressure: %.1f hPa\n", hourlyForecast.getDateTime().toString(), hourlyForecast.getMainParameters().getTemperature(), hourlyForecast.getMainParameters().getHumidity(), hourlyForecast.getMainParameters().getPressure());
    }
}

