/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.nodejs;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.nodejs.search.IsPackageJson;

public final class UpgradeDependencyVersion
extends Recipe {
    @Option(displayName="Name pattern", description="Name glob pattern used to match dependencies", example="@apollo*")
    private final String namePattern;
    @Option(displayName="Version", description="Set the version to upgrade to.Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.", example="1.x")
    private final String version;

    public String getDisplayName() {
        return "Upgrade Node.js dependencies";
    }

    public String getDescription() {
        return "Upgrade matching Node.js direct dependencies.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher dependency = new JsonPathMatcher("$.dependencies");
        final JsonPathMatcher devDependencies = new JsonPathMatcher("$.devDependencies");
        return Preconditions.check(new IsPackageJson(), (TreeVisitor)new JsonIsoVisitor<ExecutionContext>(){

            public Json.Member visitMember(Json.Member member, ExecutionContext ctx) {
                Json.Literal versionLiteral;
                String requestedVersion;
                String name;
                Json.Member m = super.visitMember(member, (Object)ctx);
                Cursor maybeDependencies = this.getCursor().getParent(2);
                if (maybeDependencies != null && (dependency.matches(maybeDependencies) || devDependencies.matches(maybeDependencies)) && StringUtils.matchesGlob((String)(name = ((Json.Literal)member.getKey()).getValue().toString()), (String)UpgradeDependencyVersion.this.namePattern) && !(requestedVersion = (versionLiteral = (Json.Literal)member.getValue()).getValue().toString()).equals(UpgradeDependencyVersion.this.version)) {
                    m = m.withValue((JsonValue)versionLiteral.withValue((Object)UpgradeDependencyVersion.this.version).withSource("\"" + UpgradeDependencyVersion.this.version + "\""));
                }
                return m;
            }
        });
    }

    public UpgradeDependencyVersion(String namePattern, String version) {
        this.namePattern = namePattern;
        this.version = version;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "UpgradeDependencyVersion(namePattern=" + this.getNamePattern() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namePattern = this.getNamePattern();
        String other$namePattern = other.getNamePattern();
        if (this$namePattern == null ? other$namePattern != null : !this$namePattern.equals(other$namePattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namePattern = this.getNamePattern();
        result = result * 59 + ($namePattern == null ? 43 : $namePattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

