/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.apache.commons.io;

import org.jetbrains.annotations.NotNull;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesField;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class UseSystemLineSeparator
extends Recipe {
    public String getDisplayName() {
        return "Use `System.lineSeparator()`";
    }

    public String getDescription() {
        return "Migrate `IOUtils.LINE_SEPARATOR` to `System.lineSeparator()`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesField("org.apache.commons.io.IOUtils", "LINE_SEPARATOR");
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                if (this.getCursor().firstEnclosing(J.Import.class) == null && TypeUtils.isOfClassType((JavaType)fieldAccess.getTarget().getType(), (String)"org.apache.commons.io.IOUtils") && fieldAccess.getSimpleName().equals("LINE_SEPARATOR")) {
                    return this.useSystemLineSeparator((J)fieldAccess);
                }
                return super.visitFieldAccess(fieldAccess, (Object)ctx);
            }

            public J visitIdentifier(J.Identifier ident, ExecutionContext executionContext) {
                JavaType.Variable varType = TypeUtils.asVariable((JavaType)ident.getFieldType());
                if (varType != null && TypeUtils.isOfClassType((JavaType)varType.getOwner(), (String)"org.apache.commons.io.IOUtils") && varType.getName().equals("LINE_SEPARATOR")) {
                    return this.useSystemLineSeparator((J)ident);
                }
                return ident;
            }

            @NotNull
            private J useSystemLineSeparator(J j) {
                this.maybeRemoveImport("org.apache.commons.io.IOUtils");
                Cursor statementCursor = this.getCursor().dropParentUntil(Statement.class::isInstance);
                Statement statement = (Statement)statementCursor.getValue();
                JavaTemplate template = JavaTemplate.builder(() -> statementCursor, (String)"System.lineSeparator()").build();
                return statement.withTemplate((SourceTemplate)template, statement.getCoordinates().replace(), new Object[0]).withPrefix(j.getPrefix());
            }
        };
    }
}

