/*
 * Decompiled with CFR 0.152.
 */
package org.openrefine.benchmark;

import com.google.refine.expr.functions.ToNumber;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

public class ToNumberBenchmark {
    static Properties bindings = new Properties();

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Warmup(iterations=3, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=5, time=200, timeUnit=TimeUnit.MILLISECONDS)
    public void toDoubleNew(ExecutionPlan plan, Blackhole blackhole) {
        plan.args[0] = plan.testData;
        blackhole.consume(plan.f.call(bindings, (Object[])plan.args));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @Warmup(iterations=3, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Measurement(iterations=5, time=200, timeUnit=TimeUnit.MILLISECONDS)
    @Fork(value=1)
    public void toLongNew(ExecutionPlan plan, Blackhole blackhole) {
        plan.args[0] = plan.testDataInt;
        blackhole.consume(plan.f.call(bindings, (Object[])plan.args));
    }

    @State(value=Scope.Benchmark)
    public static class ExecutionPlan {
        @Param(value={"1000", "10000"})
        public int iterations;
        public ToNumber f;
        String[] args = new String[1];
        String testData;
        String testDataInt;
        Random rnd = new Random();

        @Setup(value=Level.Invocation)
        public void setUp() {
            this.f = new ToNumber();
            this.testData = Double.toString(this.rnd.nextDouble() * 10000.0);
            this.testDataInt = this.testData.replace(".", "");
        }
    }
}

