/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.UnexpectedTagNameException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Select {
    private final WebElement element;

    public Select(WebElement element) {
        String tagName = element.getElementName();
        if (null == tagName || !"select".equals(tagName.toLowerCase())) {
            throw new UnexpectedTagNameException("select", tagName);
        }
        this.element = element;
    }

    public boolean isMultiple() {
        String value = this.element.getAttribute("multiple");
        return value != null && "multiple".equals(value.toLowerCase());
    }

    public List<WebElement> getOptions() {
        return this.element.findElements(By.tagName((String)"option"));
    }

    public List<WebElement> getAllSelectedOptions() {
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>();
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            toReturn.add(option);
        }
        return toReturn;
    }

    public WebElement getFirstSelectedOption() {
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            return option;
        }
        throw new NoSuchElementException("No options are selected");
    }

    public void selectByVisibleText(String text) {
        StringBuilder builder = new StringBuilder(".//option[. = ");
        builder.append(this.escapeQuotes(text));
        builder.append("]");
        List options = this.element.findElements(By.xpath((String)builder.toString()));
        for (WebElement option : options) {
            option.setSelected();
        }
    }

    public void selectByIndex(int index) {
        String match = String.valueOf(index);
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index"))) continue;
            option.setSelected();
        }
    }

    public void selectByValue(String value) {
        StringBuilder builder = new StringBuilder(".//option[@value = ");
        builder.append(this.escapeQuotes(value));
        builder.append("]");
        List options = this.element.findElements(By.xpath((String)builder.toString()));
        for (WebElement option : options) {
            option.setSelected();
        }
    }

    public void deselectAll() {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect all options of a multi-select");
        }
        for (WebElement option : this.getOptions()) {
            if (!option.isSelected()) continue;
            option.toggle();
        }
    }

    public void deselectByValue(String value) {
        StringBuilder builder = new StringBuilder(".//option[@value = ");
        builder.append(this.escapeQuotes(value));
        builder.append("]");
        List options = this.element.findElements(By.xpath((String)builder.toString()));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.toggle();
        }
    }

    public void deselectByIndex(int index) {
        String match = String.valueOf(index);
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index")) || !option.isSelected()) continue;
            option.toggle();
        }
    }

    public void deselectByVisibleText(String text) {
        StringBuilder builder = new StringBuilder(".//option[. = ");
        builder.append(this.escapeQuotes(text));
        builder.append("]");
        List options = this.element.findElements(By.xpath((String)builder.toString()));
        for (WebElement option : options) {
            if (!option.isSelected()) continue;
            option.toggle();
        }
    }

    protected String escapeQuotes(String toEscape) {
        if (toEscape.indexOf("\"") > -1 && toEscape.indexOf("'") > -1) {
            String[] substrings = toEscape.split("\"");
            StringBuilder quoted = new StringBuilder("concat(");
            for (int i = 0; i < substrings.length - 1; ++i) {
                quoted.append("\"").append(substrings[i]).append("\", '\"', ");
            }
            quoted.append("\"").append(substrings[substrings.length - 1]).append("\")");
            return quoted.toString();
        }
        if (toEscape.indexOf("\"") > -1) {
            return String.format("'%s'", toEscape);
        }
        return String.format("\"%s\"", toEscape);
    }
}

