/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.pagefactory;

import java.lang.reflect.Field;
import org.openqa.selenium.By;
import org.openqa.selenium.How;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindBy;

public class Annotations {
    private Field field;

    public Annotations(Field field) {
        this.field = field;
    }

    public boolean isLookupCached() {
        return this.field.getAnnotation(CacheLookup.class) != null;
    }

    public By buildBy() {
        How how = How.ID_OR_NAME;
        String using = this.field.getName();
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (findBy != null) {
            how = findBy.how();
            using = findBy.using();
        }
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element");
    }
}

