/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.LinkedHashSet;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.handler.BySelector;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindElements
extends WebDriverHandler
implements JsonParametersAware {
    private By by;
    private Response response;

    public FindElements(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(List<Object> allParameters) throws Exception {
        JsonToBeanConverter converter = new JsonToBeanConverter();
        String method = (String)converter.convert(String.class, allParameters.get(0));
        String selector = (String)converter.convert(String.class, allParameters.get(1));
        this.by = new BySelector().pickFrom(method, selector);
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        List elements = this.getDriver().findElements(this.by);
        for (WebElement element : elements) {
            String elementId = this.getKnownElements().add(element);
            urls.add(String.format("element/%s", elementId));
        }
        this.response.setValue(urls);
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }
}

