/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.handler.BySelector;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindElement
extends WebDriverHandler
implements JsonParametersAware {
    private By by;
    private Response response;

    public FindElement(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(List<Object> allParameters) throws Exception {
        String method = (String)allParameters.get(0);
        String selector = (String)allParameters.get(1);
        this.by = new BySelector().pickFrom(method, selector);
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        WebElement element = this.getDriver().findElement(this.by);
        String elementId = this.getKnownElements().add(element);
        this.response.setValue(Collections.singletonList(String.format("element/%s", elementId)));
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }
}

