/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;

public class SnapshotScreenListener
extends AbstractWebDriverEventListener {
    private final Session session;

    public SnapshotScreenListener(Session session) {
        this.session = session;
    }

    public void onException(Throwable throwable, WebDriver driver) {
        try {
            Rectangle size = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            BufferedImage image = new Robot().createScreenCapture(size);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", outputStream);
            String encoded = new String(Base64.encodeBase64((byte[])outputStream.toByteArray()), "UTF-8");
            this.session.attachScreenshot(encoded);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

