/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.remote.PropertyMunger;
import org.openqa.selenium.remote.server.rest.Handler;
import org.openqa.selenium.remote.server.rest.Renderer;

public class RedirectResult
implements Renderer {
    private final String url;

    public RedirectResult(String url) {
        this.url = url;
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Handler handler) throws Exception {
        String[] urlParts;
        StringBuilder builder = new StringBuilder();
        builder.append(request.getServletPath());
        for (String part : urlParts = this.url.split("/")) {
            if (part.length() == 0) continue;
            builder.append("/");
            if (part.startsWith(":")) {
                builder.append(this.get(handler, part));
                continue;
            }
            builder.append(part);
        }
        response.sendRedirect(builder.toString());
    }

    private String get(Handler handler, String part) throws Exception {
        if (part.length() < 1) {
            return "";
        }
        String propertyName = part.substring(1);
        Object value = PropertyMunger.get((String)propertyName, (Object)handler);
        return value == null ? "" : String.valueOf(value);
    }
}

