/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Capabilities;
import org.openqa.selenium.remote.Context;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.SnapshotScreenListener;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private final WebDriver driver;
    private KnownElements knownElements = new KnownElements();
    private Capabilities capabilities;
    private Executor executor = Executors.newSingleThreadExecutor();
    private volatile String base64EncodedImage;

    public Session(final Capabilities capabilities) throws Exception {
        FutureTask<WebDriver> createBrowser = new FutureTask<WebDriver>(new Callable<WebDriver>(){

            @Override
            public WebDriver call() throws Exception {
                EventFiringWebDriver driver = new EventFiringWebDriver(Session.this.createNewDriverMatching(capabilities));
                driver.register((WebDriverEventListener)new SnapshotScreenListener(Session.this));
                return driver;
            }
        });
        this.execute(createBrowser);
        this.driver = createBrowser.get();
        boolean isRendered = this.isRenderingDriver(capabilities);
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(capabilities.getBrowserName(), capabilities.getVersion(), capabilities.getPlatform());
        desiredCapabilities.setJavascriptEnabled(isRendered);
        this.capabilities = desiredCapabilities;
    }

    public <X> X execute(FutureTask<X> future) throws Exception {
        this.executor.execute(future);
        return future.get();
    }

    public WebDriver getDriver(Context context) {
        return this.driver;
    }

    public KnownElements getKnownElements() {
        return this.knownElements;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    private boolean isRenderingDriver(Capabilities capabilities) {
        String browser = capabilities.getBrowserName();
        return browser != null && !"".equals(browser) && !"htmlunit".equals(browser);
    }

    private WebDriver createNewDriverMatching(Capabilities capabilities) throws Exception {
        Platform platform = capabilities.getPlatform();
        if (platform != null && !Platform.ANY.equals((Object)platform) && !Platform.getCurrent().is(platform)) {
            throw new WebDriverException("Desired operating system does not match current OS");
        }
        String browser = capabilities.getBrowserName();
        if (browser != null) {
            return this.createNewInstanceOf(browser);
        }
        if (capabilities.isJavascriptEnabled()) {
            return (WebDriver)Class.forName("org.openqa.selenium.firefox.FirefoxDriver").newInstance();
        }
        return (WebDriver)Class.forName("org.openqa.selenium.htmlunit.HtmlUnitDriver").newInstance();
    }

    private WebDriver createNewInstanceOf(String browser) throws Exception {
        if ("htmlunit".equals(browser)) {
            return (WebDriver)Class.forName("org.openqa.selenium.htmlunit.HtmlUnitDriver").newInstance();
        }
        if ("firefox".equals(browser)) {
            return (WebDriver)Class.forName("org.openqa.selenium.firefox.FirefoxDriver").newInstance();
        }
        if ("internet explorer".equals(browser)) {
            return (WebDriver)Class.forName("org.openqa.selenium.ie.InternetExplorerDriver").newInstance();
        }
        if ("safari".equals(browser)) {
            return (WebDriver)Class.forName("org.openqa.selenium.safari.SafariDriver").newInstance();
        }
        throw new WebDriverException("Unable to match browser: " + browser);
    }

    public void attachScreenshot(String base64EncodedImage) {
        this.base64EncodedImage = base64EncodedImage;
    }

    public String getAndClearScreenshot() {
        String temp = this.base64EncodedImage;
        this.base64EncodedImage = null;
        return temp;
    }
}

