/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileReaper {
    private static final Object reaperLock = new Object();
    private static ProfileReaper theGrimReaper;
    private static Set<File> deleteDirs;
    private static final Object cleanerLock;
    private static Thread cleaner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileReaper getInstance() {
        if (theGrimReaper == null) {
            Object object = reaperLock;
            synchronized (object) {
                if (theGrimReaper == null) {
                    theGrimReaper = new ProfileReaper();
                }
            }
        }
        return theGrimReaper;
    }

    public void deleteOnExit(File addToDeletes) {
        this.startCleaner();
        deleteDirs.add(addToDeletes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleaner() {
        if (cleaner != null) {
            return;
        }
        Object object = cleanerLock;
        synchronized (object) {
            if (cleaner != null) {
                return;
            }
            Deleter deleteomatic = new Deleter(deleteDirs);
            cleaner = new Thread(deleteomatic);
            cleaner.setName("WebDriver Firefox profile cleaner thread");
            Runtime.getRuntime().addShutdownHook(cleaner);
        }
    }

    public void clean(Set<File> tempDirs) {
        Thread thread = new Thread(new Deleter(tempDirs));
        thread.run();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        deleteDirs = new HashSet<File>();
        cleanerLock = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Deleter
    implements Runnable {
        private Set<File> deletes;

        public Deleter(Set<File> deleteDirs) {
            this.deletes = deleteDirs;
        }

        @Override
        public void run() {
            String reap = System.getProperty("webdriver.firefox.reap_profile", "true");
            if (!Boolean.valueOf(reap).booleanValue()) {
                return;
            }
            HashSet<File> toDelete = new HashSet<File>(this.deletes);
            for (File deleteMe : toDelete) {
                this.deleteDirectoryRecursively(deleteMe);
            }
        }

        private void deleteDirectoryRecursively(File toDelete) {
            if (!toDelete.exists()) {
                return;
            }
            if (toDelete.isFile() && toDelete.canWrite()) {
                toDelete.delete();
            } else if (toDelete.isDirectory() && toDelete.canWrite()) {
                for (File child : toDelete.listFiles()) {
                    this.deleteDirectoryRecursively(child);
                }
                toDelete.delete();
            }
        }
    }
}

