/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.openqa.selenium.Platform;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxLauncher;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.AbstractExtensionConnection;

public class NewProfileExtensionConnection
extends AbstractExtensionConnection {
    private static long TIMEOUT_IN_SECONDS = 20L;
    private static long MILLIS_IN_SECONDS = 1000L;
    private FirefoxBinary process;
    private Socket lockSocket;
    private FirefoxProfile profile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewProfileExtensionConnection(FirefoxBinary binary, FirefoxProfile profile, String host) throws IOException {
        this.profile = profile;
        this.getLock(profile.getPort());
        try {
            int portToUse = this.determineNextFreePort(host, profile.getPort());
            this.process = new FirefoxLauncher(binary).startProfile(profile, portToUse);
            this.setAddress(host, portToUse);
            this.connectToBrowser(TIMEOUT_IN_SECONDS * MILLIS_IN_SECONDS);
        }
        finally {
            this.releaseLock();
        }
    }

    protected void getLock(int port) throws IOException {
        InetSocketAddress address = this.getAddressForLock(port);
        this.lockSocket = new Socket();
        long maxWait = System.currentTimeMillis() + 45000L;
        while (System.currentTimeMillis() < maxWait) {
            try {
                if (this.isLockFree(address)) {
                    return;
                }
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IOException("Unable to bind to locking port");
    }

    protected InetSocketAddress getAddressForLock(int port) {
        int lockPort = port - 1;
        return new InetSocketAddress("localhost", lockPort);
    }

    private boolean isLockFree(InetSocketAddress address) throws IOException {
        try {
            this.lockSocket.bind(address);
            return true;
        }
        catch (BindException e) {
            return false;
        }
    }

    protected void releaseLock() throws IOException {
        if (this.lockSocket != null && this.lockSocket.isBound()) {
            this.lockSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineNextFreePort(String host, int port) throws IOException {
        int newport;
        for (newport = port; newport < port + 200; ++newport) {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(host, newport);
            try {
                socket.bind(address);
                int n = newport;
                return n;
            }
            catch (BindException e) {
                continue;
            }
            finally {
                socket.close();
            }
        }
        throw new RuntimeException(String.format("Cannot find free port in the range %d to %d ", port, newport));
    }

    public void quit() {
        try {
            this.sendMessageAndWaitForResponse(RuntimeException.class, new Command(null, "quit", new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            this.quitOnWindows();
        } else {
            this.quitOnOtherPlatforms();
        }
        this.profile.clean();
    }

    private void quitOnOtherPlatforms() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void quitOnWindows() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

