/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openqa.selenium.firefox.internal.Cleanly;

public class FileHandler {
    public static File unzip(InputStream resource) throws IOException {
        String tempName = String.valueOf(System.currentTimeMillis());
        File output = new File(System.getProperty("java.io.tmpdir"), tempName);
        output.mkdirs();
        FileHandler.makeWritable(output);
        ZipInputStream zipStream = new ZipInputStream(resource);
        ZipEntry entry = zipStream.getNextEntry();
        while (entry != null) {
            if (entry.isDirectory()) {
                FileHandler.createDir(new File(output, entry.getName()));
            } else {
                FileHandler.createFile(output, zipStream, entry.getName());
            }
            entry = zipStream.getNextEntry();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFile(File output, InputStream zipStream, String name) throws IOException {
        File toWrite = new File(output, name);
        if (!FileHandler.createDir(toWrite.getParentFile())) {
            throw new IOException("Cannot create parent director for: " + name);
        }
        FileOutputStream out = null;
        try {
            byte[] buffer;
            int read;
            out = new FileOutputStream(toWrite);
            while ((read = zipStream.read(buffer = new byte[4096])) != -1) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean createDir(File dir) throws IOException {
        if ((dir.exists() || dir.mkdirs()) && dir.canWrite()) {
            return true;
        }
        if (dir.exists()) {
            FileHandler.makeWritable(dir);
            return dir.canWrite();
        }
        return FileHandler.createDir(dir.getParentFile());
    }

    public static boolean makeWritable(File file) throws IOException {
        if (file.canWrite()) {
            return true;
        }
        try {
            Method setWritable = File.class.getMethod("setWritable", Boolean.class);
            return (Boolean)setWritable.invoke((Object)file, true);
        }
        catch (NoSuchMethodException e) {
            String[] paths;
            String allPaths = System.getenv("PATH");
            for (String path : paths = allPaths.split(File.separator)) {
                File chmod = new File(path, "chmod");
                if (!chmod.exists()) continue;
                Process process = Runtime.getRuntime().exec(new String[]{chmod.getAbsolutePath(), "+x", file.getAbsolutePath()});
                try {
                    process.waitFor();
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                return file.canWrite();
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isZipped(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".xpi");
    }

    public static boolean delete(File toDelete) {
        boolean deleted = true;
        if (toDelete.isDirectory()) {
            for (File child : toDelete.listFiles()) {
                deleted &= FileHandler.delete(child);
            }
        }
        return deleted && toDelete.delete();
    }

    public static void copyDir(File from, File to) {
        String[] contents;
        for (String child : contents = from.list()) {
            File toCopy = new File(from, child);
            File target = new File(to, child);
            if (toCopy.isDirectory()) {
                target.mkdir();
                FileHandler.copyDir(toCopy, target);
                continue;
            }
            if (".parentlock".equals(child) || "parent.lock".equals(child)) continue;
            FileHandler.copyFile(toCopy, target);
        }
    }

    private static void copyFile(File from, File to) {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(to));
            in = new BufferedInputStream(new FileInputStream(from));
            int read = in.read();
            while (read != -1) {
                out.write(read);
                read = in.read();
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Cleanly.close(out);
                Cleanly.close(in);
                throw throwable;
            }
        }
        Cleanly.close(out);
        Cleanly.close(in);
    }
}

