/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.IOException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.DisconnectedExtension;
import org.openqa.selenium.firefox.internal.NewProfileExtensionConnection;
import org.openqa.selenium.firefox.internal.RunningInstanceConnection;

public class ExtensionConnectionFactory {
    public static ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        boolean isDev = Boolean.getBoolean("webdriver.firefox.useExisting");
        if (isDev) {
            try {
                return new RunningInstanceConnection(host, profile.getPort());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            return new NewProfileExtensionConnection(binary, profile, host);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DisconnectedExtension();
        }
    }
}

