/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.IOException;
import java.net.ConnectException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.firefox.internal.RunningInstanceConnection;

public class FirefoxLauncher {
    private final FirefoxBinary binary;

    public FirefoxLauncher(FirefoxBinary binary) {
        this.binary = binary;
    }

    public static void main(String[] args) throws IOException {
        FirefoxLauncher launcher = new FirefoxLauncher(new FirefoxBinary());
        if (args.length == 0) {
            launcher.createBaseWebDriverProfile("WebDriver");
        } else if (args.length == 1) {
            launcher.createBaseWebDriverProfile(args[0]);
        } else {
            launcher.createBaseWebDriverProfile(args[0], Integer.parseInt(args[1]));
        }
    }

    public void createBaseWebDriverProfile() throws IOException {
        this.createBaseWebDriverProfile(null);
    }

    public void createBaseWebDriverProfile(String profileName) throws IOException {
        this.createBaseWebDriverProfile(profileName, 7055);
    }

    public void createBaseWebDriverProfile(String profileName, int port) throws IOException {
        this.connectAndKill(port);
        System.out.println(String.format("Creating %s", profileName));
        try {
            this.binary.createProfile(profileName);
            System.out.println("Profile created");
            this.binary.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ProfilesIni allProfiles = new ProfilesIni();
        FirefoxProfile profile = allProfiles.getProfile(profileName);
        if (profile == null) {
            throw new IllegalStateException(String.format("Unable to locate profile \"%s\"", profileName));
        }
        System.out.println("Attempting to install the WebDriver extension");
        profile.addWebDriverExtensionIfNeeded(true);
        System.out.println("Updating user preferences with common, useful settings");
        profile.setPort(port);
        profile.updateUserPrefs();
        System.out.println("Deleting existing extensions cache (if it already exists)");
        profile.deleteExtensionsCacheIfItExists();
        System.out.println("Firefox should now start and quit");
        this.binary.startProfile(profile, new String[0]);
        this.repeatedlyConnectUntilFirefoxAppearsStable(port);
    }

    private void repeatedlyConnectUntilFirefoxAppearsStable(int port) {
        long maxWaitTime = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < maxWaitTime) {
            try {
                RunningInstanceConnection connection = new RunningInstanceConnection("localhost", port, 1000L);
                Thread.sleep(2000L);
                connection.quit();
                return;
            }
            catch (ConnectException e) {
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void connectAndKill(int port) {
        try {
            RunningInstanceConnection connection = new RunningInstanceConnection("localhost", port, 5000L);
            connection.quit();
        }
        catch (ConnectException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FirefoxBinary startProfile(FirefoxProfile profile, int port) throws IOException {
        FirefoxBinary binaryToUse = this.binary;
        if (this.binary == null) {
            binaryToUse = new FirefoxBinary();
        }
        FirefoxProfile profileToUse = profile.createCopy(port);
        binaryToUse.clean(profileToUse);
        binaryToUse.startProfile(profileToUse, new String[0]);
        return binaryToUse;
    }
}

