/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Platform;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Cleanly;

public class FirefoxBinary {
    private final Map<String, String> extraEnv = new HashMap<String, String>();
    private final File actualBinary;
    private Process process;

    public FirefoxBinary() {
        this(null);
    }

    public FirefoxBinary(File actualBinary) {
        this.actualBinary = this.locateFirefoxBinary(actualBinary);
    }

    public void startProfile(FirefoxProfile profile, String ... commandLineFlags) throws IOException {
        this.setEnvironmentProperty("XRE_PROFILE_PATH", profile.getProfileDir().getAbsolutePath());
        this.setEnvironmentProperty("MOZ_NO_REMOTE", "1");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.actualBinary.getAbsolutePath());
        commands.addAll(Arrays.asList(commandLineFlags));
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.environment().putAll(this.extraEnv);
        this.modifyLibraryPath(builder);
        this.process = builder.start();
    }

    public void setEnvironmentProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new RuntimeException(String.format("You must set both the property name and value: %s, %s", propertyName, value));
        }
        this.extraEnv.put(propertyName, value);
    }

    public void createProfile(String profileName) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.actualBinary.getAbsolutePath(), "-CreateProfile", profileName).redirectErrorStream(true);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        this.process = builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        try {
            while (reader.readLine() != null) {
                this.sleep(100L);
            }
        }
        finally {
            reader.close();
        }
    }

    protected void modifyLibraryPath(ProcessBuilder builder) {
        String propertyName;
        Platform os = Platform.getCurrent();
        switch (os) {
            case MAC: {
                propertyName = "DYLD_LIBRARY_PATH";
                break;
            }
            case WINDOWS: {
                propertyName = "PATH";
                break;
            }
            default: {
                propertyName = "LD_LIBRARY_PATH";
            }
        }
        StringBuilder libraryPath = new StringBuilder();
        String env = System.getenv(propertyName);
        if (env != null) {
            libraryPath.append(env).append(File.pathSeparator);
        }
        if ((env = this.extraEnv.get(propertyName)) != null) {
            libraryPath.append(env).append(File.pathSeparator);
        }
        String firefoxLibraryPath = System.getProperty("webdriver.firefox.library.path", this.actualBinary.getParentFile().getAbsolutePath());
        libraryPath.append(firefoxLibraryPath).append(File.pathSeparator).append((CharSequence)libraryPath);
        builder.environment().put(propertyName, libraryPath.toString());
    }

    protected File locateFirefoxBinary(File suggestedLocation) {
        if (suggestedLocation != null) {
            if (suggestedLocation.exists() && suggestedLocation.isFile()) {
                return suggestedLocation;
            }
            throw new RuntimeException("Given firefox binary location does not exist or is not a real file: " + suggestedLocation);
        }
        File binary = this.locateFirefoxBinaryFromSystemProperty();
        if (binary != null) {
            return binary;
        }
        Platform platform = Platform.getCurrent();
        switch (platform) {
            case WINDOWS: 
            case VISTA: 
            case XP: {
                String programFiles = System.getenv("PROGRAMFILES");
                if (programFiles == null) {
                    programFiles = "\\Program Files";
                }
                binary = new File(programFiles + "\\Mozilla Firefox\\firefox.exe");
                break;
            }
            case MAC: {
                binary = new File("/Applications/Firefox.app/Contents/MacOS/firefox");
                break;
            }
            default: {
                String name;
                String[] binaryNames;
                String[] arr$ = binaryNames = new String[]{"firefox3", "firefox2", "firefox"};
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (binary = this.shellOutAndFindPathOfFirefox(name = arr$[i$])) == null; ++i$) {
                }
            }
        }
        if (binary == null) {
            throw new RuntimeException("Cannot find firefox binary in PATH. Make sure firefox is installed. OS appears to be: " + Platform.getCurrent());
        }
        if (binary.exists()) {
            return binary;
        }
        throw new RuntimeException("Unable to locate firefox binary. Please check that it is installed in the default location, or the path given points to the firefox binary. I would have used: " + binary.getPath());
    }

    protected File locateFirefoxBinaryFromSystemProperty() {
        String binaryName = System.getProperty("webdriver.firefox.bin");
        if (binaryName == null) {
            return null;
        }
        File binary = new File(binaryName);
        if (binary.exists()) {
            return binary;
        }
        switch (Platform.getCurrent()) {
            case WINDOWS: 
            case VISTA: 
            case XP: {
                return null;
            }
            case MAC: {
                if (!binaryName.endsWith(".app")) {
                    binaryName = binaryName + ".app";
                }
                binaryName = binaryName + "/Contents/MacOS/firefox";
                return new File(binaryName);
            }
        }
        return this.shellOutAndFindPathOfFirefox(binaryName);
    }

    private File shellOutAndFindPathOfFirefox(String binaryName) {
        String fullPath = System.getenv("PATH");
        for (String path : fullPath.split(":")) {
            File file = new File(path, binaryName);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private String getNextLineOfOutputFrom(Process process) {
        String string;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string = reader.readLine();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Cleanly.close(reader);
                throw throwable;
            }
        }
        Cleanly.close(reader);
        return string;
    }

    private void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void clean(FirefoxProfile profile) throws IOException {
        this.startProfile(profile, "-silent");
        try {
            this.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            while (profile.isRunning()) {
                this.sleep(500L);
            }
            do {
                this.sleep(500L);
            } while (profile.isRunning());
        }
    }
}

