/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private final JSONObject result;
    private final String methodName;
    private final Context context;
    private final String responseText;
    private boolean isError;

    public Response(String json) {
        try {
            this.result = new JSONObject(json.trim());
            this.methodName = (String)this.result.get("commandName");
            String contextAsString = (String)this.result.get("context");
            this.context = contextAsString != null ? new Context(contextAsString) : null;
            this.responseText = String.valueOf(this.result.get("response"));
            this.isError = (Boolean)this.result.get("isError");
        }
        catch (Exception e) {
            throw new WebDriverException("Could not parse \"" + json.replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") + "\".", (Throwable)e);
        }
    }

    public String getCommand() {
        return this.methodName;
    }

    public Context getContext() {
        return this.context;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public boolean isError() {
        return this.isError;
    }

    public String toString() {
        return this.result.toString();
    }

    public Object getExtraResult(String fieldName) {
        try {
            return this.result.get(fieldName);
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void ifNecessaryThrow(Class<? extends RuntimeException> exceptionClass) {
        if (!this.isError) {
            return;
        }
        if (this.responseText.startsWith("element is obsolete")) {
            throw new StaleElementReferenceException("Element is obsolete");
        }
        if (this.responseText.startsWith("Element is not currently visible")) {
            throw new ElementNotVisibleException("Element is not visible, and so cannot be interacted with");
        }
        RuntimeException toThrow = null;
        try {
            Constructor<? extends RuntimeException> constructor = exceptionClass.getConstructor(String.class);
            JSONObject info = null;
            try {
                info = new JSONObject(this.getResponseText());
            }
            catch (Exception e) {
                toThrow = constructor.newInstance(this.getResponseText());
            }
            if (info != null) {
                toThrow = constructor.newInstance(String.format("%s: %s", info.get("name"), info.get("message")));
                ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
                if (info.has("stack")) {
                    for (String trace : ((String)info.get("stack")).split("\n")) {
                        StackTraceElement element = this.createStackTraceElement(trace);
                        if (element == null) continue;
                        stack.add(element);
                    }
                }
                stack.addAll(Arrays.asList(toThrow.getStackTrace()));
                toThrow.setStackTrace(stack.toArray(new StackTraceElement[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebDriverException(this.getResponseText());
        }
        throw toThrow;
    }

    private StackTraceElement createStackTraceElement(String trace) {
        try {
            String[] parts = trace.split(" -> ");
            int splitAt = parts[1].lastIndexOf(":");
            int lineNumber = Integer.parseInt(parts[1].substring(splitAt + 1));
            return new StackTraceElement("FirefoxDriver", parts[0], parts[1].substring(0, splitAt), lineNumber);
        }
        catch (Exception e) {
            return null;
        }
    }
}

