/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Executable;
import org.openqa.selenium.firefox.internal.Streams;

public class FirefoxBinary {
    private final Map<String, String> extraEnv = new HashMap<String, String>();
    private final Executable executable;
    private Process process;
    private long timeout = TimeUnit.SECONDS.toMillis(45L);
    private OutputStream stream;
    private Thread outputWatcher;

    public FirefoxBinary() {
        this(null);
    }

    public FirefoxBinary(File pathToFirefoxBinary) {
        this.executable = new Executable(pathToFirefoxBinary);
    }

    public void startProfile(FirefoxProfile profile, String ... commandLineFlags) throws IOException {
        this.setEnvironmentProperty("XRE_PROFILE_PATH", profile.getProfileDir().getAbsolutePath());
        this.setEnvironmentProperty("MOZ_NO_REMOTE", "1");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.executable.getPath());
        commands.add("--verbose");
        commands.addAll(Arrays.asList(commandLineFlags));
        ProcessBuilder builder = new ProcessBuilder(commands);
        builder.redirectErrorStream(true);
        builder.environment().putAll(this.extraEnv);
        this.executable.setLibraryPath(builder, this.extraEnv);
        if (this.stream == null) {
            this.stream = this.executable.getDefaultOutputStream();
        }
        this.process = builder.start();
        this.outputWatcher = new Thread((Runnable)new OutputWatcher(this.process, this.stream), "Firefox output watcher");
        this.outputWatcher.start();
    }

    public void setEnvironmentProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new WebDriverException(String.format("You must set both the property name and value: %s, %s", propertyName, value));
        }
        this.extraEnv.put(propertyName, value);
    }

    public void createProfile(String profileName) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.executable.getPath(), "--verbose", "-CreateProfile", profileName).redirectErrorStream(true);
        builder.environment().put("MOZ_NO_REMOTE", "1");
        if (this.stream == null) {
            this.stream = this.executable.getDefaultOutputStream();
        }
        this.process = builder.start();
        this.outputWatcher = new Thread(new OutputWatcher(this.process, this.stream));
        this.outputWatcher.start();
    }

    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor();
    }

    public String getConsoleOutput() throws IOException {
        if (this.process == null) {
            return null;
        }
        return Streams.drainStream(this.stream);
    }

    private void sleep(long timeInMillis) {
        try {
            Thread.sleep(timeInMillis);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void clean(FirefoxProfile profile) throws IOException {
        this.startProfile(profile, "-silent");
        try {
            this.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            while (profile.isRunning()) {
                this.sleep(500L);
            }
            do {
                this.sleep(500L);
            } while (profile.isRunning());
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return "FirefoxBinary(" + this.executable.getPath() + ")";
    }

    public void setOutputWatcher(OutputStream stream) {
        this.stream = stream;
    }

    private static class OutputWatcher
    implements Runnable {
        private Process process;
        private OutputStream stream;

        public OutputWatcher(Process process, OutputStream stream) {
            this.process = process;
            this.stream = stream;
        }

        public void run() {
            int in = 0;
            while (in != -1) {
                try {
                    in = this.process.getInputStream().read();
                    this.stream.write(in);
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }
    }
}

